#!/bin/bash

cc_cloud_type_mst_data="('AWS','AWS','AWS')"

cc_cloud_service_data="('AWS','Amazon Web Services','AWS','http://aws.amazon.com/jp/',null,null,'','')"

cc_cloud_region_data="\
('us-east-1','AWS','US East (Northern Virginia)','EC2 Availability Zones: 5*    Launched 2006'),\
('us-west-2','AWS','US West (Oregon)','EC2 Availability Zones: 3    Launched 2011'),\
('us-west-1','AWS','US West (Northern California)','EC2 Availability Zones: 3*    Launched 2009'),\
('eu-west-1','AWS','EU (Ireland)','EC2 Availability Zones: 3    Launched 2007'),\
('ap-southeast-1','AWS','Asia Pacific (Singapore)','EC2 Availability Zones: 2    Launched 2010'),\
('ap-southeast-2','AWS','Asia Pacific (Sydney)','EC2 Availability Zones: 2    Launched 2012'),\
('ap-northeast-1','AWS','Asia Pacific (Tokyo)','EC2 Availability Zones: 3    Launched 2011'),\
('sa-east-1','AWS','South America (Sao Paulo)','EC2 Availability Zones: 2    Launched 2011')"

cc_cloud_endpoint_data="\
('ec2','AWS','us-east-1','ec2.us-east-1.amazonaws.com'),\
('ec2','AWS','us-west-2','ec2.us-west-2.amazonaws.com'),\
('ec2','AWS','us-west-1','ec2.us-west-1.amazonaws.com'),\
('ec2','AWS','eu-west-1','ec2.eu-west-1.amazonaws.com'),\
('ec2','AWS','ap-southeast-1','ec2.ap-southeast-1.amazonaws.com'),\
('ec2','AWS','ap-southeast-2','ec2.ap-southeast-2.amazonaws.com'),\
('ec2','AWS','ap-northeast-1','ec2.ap-northeast-1.amazonaws.com'),\
('ec2','AWS','sa-east-1','ec2.sa-east-1.amazonaws.com'),\
('elb','AWS','us-east-1','elasticloadbalancing.us-east-1.amazonaws.com'),\
('elb','AWS','us-west-2','elasticloadbalancing.us-west-2.amazonaws.com'),\
('elb','AWS','us-west-1','elasticloadbalancing.us-west-1.amazonaws.com'),\
('elb','AWS','eu-west-1','elasticloadbalancing.eu-west-1.amazonaws.com'),\
('elb','AWS','ap-southeast-1','elasticloadbalancing.ap-southeast-1.amazonaws.com'),\
('elb','AWS','ap-southeast-2','elasticloadbalancing.ap-southeast-2.amazonaws.com'),\
('elb','AWS','ap-northeast-1','elasticloadbalancing.ap-northeast-1.amazonaws.com'),\
('elb','AWS','sa-east-1','elasticloadbalancing.sa-east-1.amazonaws.com'),\
('CloudWatch','AWS','us-east-1','monitoring.us-east-1.amazonaws.com'),\
('CloudWatch','AWS','us-west-2','monitoring.us-west-2.amazonaws.com'),\
('CloudWatch','AWS','us-west-1','monitoring.us-west-1.amazonaws.com'),\
('CloudWatch','AWS','eu-west-1','monitoring.eu-west-1.amazonaws.com'),\
('CloudWatch','AWS','ap-southeast-1','monitoring.ap-southeast-1.amazonaws.com'),\
('CloudWatch','AWS','ap-southeast-2','monitoring.ap-southeast-2.amazonaws.com'),\
('CloudWatch','AWS','ap-northeast-1','monitoring.ap-northeast-1.amazonaws.com'),\
('CloudWatch','AWS','sa-east-1','monitoring.sa-east-1.amazonaws.com')"

if [ ! $(printenv PGPASSWORD) ] ; then
	read -s -p 'Password for user hinemos: ' PASSWD
	if [ "${PASSWD}" != "" ] ; then
	    export PGPASSWORD=${PASSWD}
	fi
	echo
fi

${HINEMOS_HOME}/postgresql/bin/psql -p 24001 -U hinemos -v operation=${1} << EOF >> /dev/null
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;
SET search_path = public,pg_catalog;

`cat ${SCRIPT_DIR}/scripts/cloud_data_create_maint.sql`

select cloud_maint_operation(
	:'operation',
	CAST(ARRAY[${cc_cloud_type_mst_data}] AS cc_cloud_type_mst[]),
	CAST(ARRAY[${cc_cloud_service_data}] AS cc_cloud_service[]),
	CAST(ARRAY[${cc_cloud_region_data}] AS cc_cloud_region[]),
	CAST(ARRAY[${cc_cloud_endpoint_data}] AS cc_cloud_endpoint[])
	);

`cat ${SCRIPT_DIR}/scripts/cloud_data_drop_maint.sql`
EOF