/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.IUserManagement.User.UserKind;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.aws.util.AWSUtil;
import com.clustercontrol.cloud.util.CloudCredential;

public class AWSUserManagement implements IUserManagement {
	private ICredential credential;

	@Override
	public void setCredential(ICredential credential) {
		this.credential = credential;
	}

	@Override
	public User getCurrentUser() throws CloudManagerFault {
		try {
			AmazonIdentityManagement aim = AWSUtil.createIAM(new CloudCredential(credential.getAccessKey(), credential.getSecretKey()));
			GetUserResult result = aim.getUser();
	
			AWSUtil.AMIArn arn = new AWSUtil.AMIArn(result.getUser().getArn());
			return new User(arn.userName, arn.isRoot() ? UserKind.account: UserKind.user);
		}
		catch (AmazonServiceException e) {
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}
		catch (Exception e) {
			throw new InternalManagerError(e);
		}
	}
}
