/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.hinemosagent.util.AgentConnectUtil;

public class RegistAgent implements Runnable {
	private String facilityId;
	private int count = 0;
	private int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
	
	public RegistAgent(String facilityId) {
		this.facilityId = facilityId;
	}

	@Override
	public void run() {
		Logger logger = Logger.getLogger(this.getClass());
		++count;
		logger.debug("try to regist agent " + facilityId + " " + count + "/" + maxCount + " time.");

		boolean success = false;
		try {
			// ノードが削除されていないか確認。
			// sendManagerDiscoveryInfo は、FacilityNotFound　をスローしないので必要。
			RepositoryControllerBeanWrapper.bean().getNode(facilityId);
			success = AgentConnectUtil.sendManagerDiscoveryInfo(facilityId);
		}
		catch (FacilityNotFound e) {
			logger.warn(e.getMessage(), e);
			// 終了のために RuntimeException をスロー。
			throw new RuntimeException();
		}
		catch (Exception e) {
			logger.warn(e.getMessage(), e);
		}

		if (success) {
			logger.info("success to regist " + facilityId + " as agent.");
			// 終了のために RuntimeException をスロー。
			throw new RuntimeException();
		}
		
		if (maxCount <= count) {
			logger.warn("timed out. agent doesn't exist.");
			// 終了のために RuntimeException をスロー。
			throw new RuntimeException();
		}
	}

	public void asyncRegistAgent() {
		Logger logger = Logger.getLogger(InstanceOperator.class);
		logger.info("start to ping " + facilityId + " as agent for register.");
		SessionService.scheduleWithFixedDelay(this, 0, Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()), TimeUnit.MILLISECONDS);
	}

	public void registAgent() {
		Logger logger = Logger.getLogger(InstanceOperator.class);
		logger.info("start to ping " + facilityId + " as agent for register.");
		
		try {
			for (;;) {
				run();
				Thread.sleep(Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()));
			}
		}
		catch (Exception e) {
		}
	}

	public Boolean findAgent() throws CloudManagerFault {
		Logger logger = Logger.getLogger(TemplateJobUtil.class);

		try {
			logger.info("start to check " + facilityId + " as agent for register.");

			boolean result = false;
			int counter = 0;
			int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
			long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
			while (counter < maxCount) {
				counter++;
				logger.debug("trｙ to find agent " + facilityId + " " + counter + "/" + maxCount + " time.");

				// ノードが削除されていないか確認。
				RepositoryControllerBeanWrapper.bean().getNode(facilityId);

				if (AgentConnectUtil.isValidAgent(facilityId)) {
					logger.info("success to find " + facilityId + " as agent.");
					return true;
				}

				if (counter >= maxCount) {
					throw new CloudManagerFault("timed out. agent doesn't exist.");
				}
				Thread.sleep(interval);
			}
			
			return result;
		}
		catch (Exception e) {
			throw new CloudManagerFault(e);
		}
	}

	public static void asyncRegistAgent(String facilityId) {
		new RegistAgent(facilityId).asyncRegistAgent();
	}

	public static void registAgent(String facilityId) {
		// 失敗か成功かなどの結果は、現時点では通知しない。
		new RegistAgent(facilityId).registAgent();
	}
	
	public static Boolean findAgent(String facilityId) throws CloudManagerFault {
		return new RegistAgent(facilityId).findAgent();
	}
}