/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

public class NodeDetail {
	private String facilityId;
	private String facilityName;
	private String nodeName;
	private String description;
	private Boolean replaceNode;

	@ElementId("facilityId")
	@Identity(groups={"addInstance", "addInstanceByTemplate", "restoreInstance", "RegistNodeRequest"})
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	@ElementId("facilityName")
	@NotNull(groups={"addInstance"})
	@Size(max=128)
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	@ElementId("nodeName")
	@NotNull(groups={"addInstance"})
	@Size(max=128)
	public String getNodeName() {
		return nodeName;
	}
	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}
	@ElementId("description")
	@NotNull(groups={"addInstance"})
	@Size(max=256)
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getReplaceNode() {
		return replaceNode;
	}
	public void setReplaceNode(Boolean replaceNode) {
		this.replaceNode = replaceNode;
	}
}
