/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * ストレージバックアップ情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addStorageBackup(CreateStorageBackupRequest request) addStorageBackup 関数} にて使用される。
 *
 */
public class CreateStorageBackupRequest extends CloudRequest {
	private String storageId;
	private String snapshotName;
	private String description;
	private String snapshotDetail;
	
	public CreateStorageBackupRequest() {
	}
	
	/**
	 * ストレージ Id を取得する。
	 * 
	 * @return ストレージ Id
	 */
	@ElementId("storageId")
	@NotNull
	@Size(max=64)
	public String getStorageId() {
		return storageId;
	}
	/**
	 * ストレージ Id を取得する。
	 * 
	 * @param storageId　ストレージ Id
	 */
	public void setStorageId(String storageId) {
		this.storageId = storageId;
	}
	/**
	 * スナップショット名を取得する。
	 * 
	 * @param storageId　ストレージ Id
	 */
	@ElementId("snapshotName")
	@NotNull
	@Size(max=128)
	public String getSnapshotName() {
		return snapshotName;
	}
	/**
	 * スナップショット名を指定する。
	 * 
	 * @param storageId　ストレージ Id
	 */
	public void setSnapshotName(String snapshotName) {
		this.snapshotName = snapshotName;
	}
	/**
	 * 説明を取得する。
	 * 
	 * @return　説明。
	 */
	@ElementId("description")
	@Size(max = 256)
	public String getDescription() {
		return description;
	}
	/**
	 * 説明を指定する。
	 * 
	 * @param description 説明。
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	public String getSnapshotDetail() {
		return snapshotDetail;
	}

	public void setSnapshotDetail(String snapshotDetail) {
		this.snapshotDetail = snapshotDetail;
	}
}