/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;

/**
 * テンプレート付きクラウドインスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(CreateInstanceByTemplateRequest request) addInstanceByTemplate 関数} にて使用される。
 *
 */
public class CreateInstanceByTemplateRequest extends CloudRequest {
	private NodeDetail nodeDetail;

	private String flavor;
	private String templateId;
	private String zone;
	private String instanceDetail;
	private List<Tag> tags = new ArrayList<Tag>();
	
	private List<TemplateJobsArgument> arguments;

	/**
	 * ノード作成に必要な情報を返す。
	 * 
	 * @return ノード作成情報。
	 */
	@ElementId("NodeDetail")
	@NotNull
	@Into
	public NodeDetail getNodeDetail() {
		return nodeDetail;
	}

	/**
	 * ノード作成情報を指定する。
	 * この値は、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(CreateInstanceByTemplateRequest request) addInstanceByTemplate 関数} を実行する際、必須となります。
	 * 
	 * @param nodeDetail ノード作成情報。
	 */
	public void setNodeDetail(NodeDetail nodeDetail) {
		this.nodeDetail = nodeDetail;
	}

	/**
	 * 使用するテンプレートの Id を取得する。
	 * 
	 * @return テンプレート Id
	 */
	@ElementId("templateId")
	@Identity
	public String getTemplateId() {
		return templateId;
	}

	/**
	 * 使用するテンプレートの Id を指定する。
	 * この値は、64 文字以内で、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(CreateInstanceByTemplateRequest request) addInstanceByTemplate 関数} を実行する際、必須となります。
	 * 
	 * @param templateId テンプレート Id
	 */
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getZone() {
		return zone;
	}
	public void setZone(String zone) {
		this.zone = zone;
	}
	
	@NotNull
	@ElementId("tags")
//	@ListElement
	public List<Tag> getTags() {
		return tags;
	}
	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
	
	/**
	 * テンプレートジョブに渡す引数リストを取得する。
	 * 
	 * @return ジョブの引数リスト
	 */
	@NotNull
	@ElementId("templateArguments")
//	@ListElement
	public List<TemplateJobsArgument> getArguments() {
		return arguments;
	}

	/**
	 * テンプレートジョブに渡す引数リストを指定する。
	 * 
	 * @param arguments ジョブの引数リスト
	 */
	public void setArguments(List<TemplateJobsArgument> arguments) {
		this.arguments = arguments;
	}

	public String getFlavor() {
		return flavor;
	}
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}

	public String getInstanceDetail() {
		return instanceDetail;
	}
	public void setInstanceDetail(String instanceDetail) {
		this.instanceDetail = instanceDetail;
	}
}
