/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator.EntityValidationContext;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;


/**
 * インスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(CreateCloudAccountResourceRequest request) addInstance 関数} にて使用される。
 *
 */
@CustomEntityValidation(CreateAccountResourceRequest.CloudUserValidator.class)
public class CreateAccountResourceRequest extends CloudRequest {
	public static class CloudUserValidator implements CustomEntityValidator<CreateAccountResourceRequest>, ValidationConstants {
		@Override
		public void validate(final CreateAccountResourceRequest entity, String group, IMessagesHolder messages, EntityValidationContext context) throws ValidationFault {
			try {
				// クラウド側にユーザー情報が存在するか確認。
				IUserManagement um = ObjectRegistryService.registry().get(IUserManagement.class, entity.getCloudServiceId());
				um.setCredential(new IUserManagement.Credential(entity.getAccount().getAccessKey(), entity.getAccount().getSecretKey()));
				um.getCurrentUser();
				
//				IUserManagement.User user = um.getCurrentUser();

//				if (user.getKind() != IUserManagement.User.UserKind.account) {
//					throw new ValidationFault(ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.getMessage(), ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.name());
//				}
			}
			catch (CloudManagerFault e) {
				throw new ValidationFault(e.getMessage(), e.getErrorCode(), e);
			}
		}
	}

	public static class Account {
		private String cloudUserId;
		private String cloudUserName;
		private String description;
		private String accessKey;
		private String secretKey;
		private String roleId;
		
		@ElementId("cloudUserId")
		@Identity
		public String getCloudUserId() {
			return cloudUserId;
		}
		public void setCloudUserId(String cloudUserId) {
			this.cloudUserId = cloudUserId;
		}
		@ElementId("cloudUserName")
		@Size(max=128)
		@NotNull
		public String getCloudUserName() {
			return cloudUserName;
		}
		public void setCloudUserName(String cloudUserName) {
			this.cloudUserName = cloudUserName;
		}
		@ElementId("description")
		@Size(max = 256)
		@NotNull
		public String getDescription() {
			return description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getAccessKey() {
			return accessKey;
		}
		public void setAccessKey(String accessKey) {
			this.accessKey = accessKey;
		}
		public String getSecretKey() {
			return secretKey;
		}
		public void setSecretKey(String secretKey) {
			this.secretKey = secretKey;
		}
		@ElementId("roleId")
		@Identity
		public String getRoleId() {
			return roleId;
		}
		public void setRoleId(String roleId) {
			this.roleId = roleId;
		}
	}
	
	private String accountResourceId;
	private String accountResourceName;
	private String cloudServiceId;
	private String description;
	private Account account;

	public CreateAccountResourceRequest() {
	}	

	@ElementId("accountResourceId")
	@Identity
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}

	@ElementId("accountResourceName")
	@Size(max=128)
	@NotNull
	public String getAccountResourceName() {
		return accountResourceName;
	}

	public void setAccountResourceName(String accountResourceName) {
		this.accountResourceName = accountResourceName;
	}

	@ElementId("cloudServiceId")
	@Identity
	public String getCloudServiceId() {
		return cloudServiceId;
	}
	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}

	@ElementId("description")
	@Size(max = 256)
	@NotNull
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	@ElementId("accountResourceAccount")
	@NotNull
	@Into
	public Account getAccount() {
		return account;
	}

	public void setAccount(Account account) {
		this.account = account;
	}
}
