/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloud;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.bean.AvailableRole;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateAccountResourceRequest;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.ModifyAccountBillingDetailRequest;
import com.clustercontrol.cloud.bean.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

@WebService(targetNamespace="http://cloud.ws.clustercontrol.com")
public interface CloudEndpoint {
    @WebMethod
    public CloudInstance addInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") CreateInstanceRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstance addInstanceByTemplate(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") CreateInstanceByTemplateRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstance restoreInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") RestoreInstanceRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstance getInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudInstance> getInstancesByRegion(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public InstanceStateChange startInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") StartInstanceRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public InstanceStateChange stopInstance(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") StopInstanceRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudUser addCloudUser(@NotNull @Into @WebParam(name="request") CreateCloudUserRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudUser getCloudUser(@WebParam(name="userId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeCloudUser(@WebParam(name="userId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudUser> getCloudUsersByAccountResource(@WebParam(name="accountResourceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudUser modifyCloudUser(@WebParam(name="request") ModifyCloudUserRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudType> getAllSupportedCloudTypes() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudRegion> getRegionsByService(@WebParam(name="cloudServiceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<Zone> getZones(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<Image> getImagesWithFilter(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="filters") List<Filter> var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getInstanceFlavorsByService(@WebParam(name="serviceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<Snapshot> getSnapshotsWithFilter(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="filter") List<Filter> var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void attachStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceId") String var3, @WebParam(name="storageId") String var4, @WebParam(name="device") String var5) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void detachStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceId") String var3, @WebParam(name="storageId") String var4) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudStorage addStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") CreateStorageRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudStorage restoreStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") RestoreStorageRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="storageId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudStorage getStorage(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="storageId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudStorage> getStoragesByRegion(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getStorageFlavorsByService(@WebParam(name="cloudServiceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudStorageBackup addStorageBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") CreateStorageBackupRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeStorageBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="storageBackupId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudStorageBackup getStorageBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="storageBackupId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudStorageBackup> getStorageBackupsByRegion(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstanceBackup addInstanceBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") CreateInstanceBackupRequest var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeInstanceBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceBackupId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstanceBackup getInstanceBackup(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceBackupId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudInstance registNode(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="request") RegistNodeRequest var3) throws InvalidUserPass, InvalidRole, CloudManagerFault;

    @WebMethod
    public void unregistNode(@WebParam(name="roleId") String var1, @WebParam(name="region") String var2, @WebParam(name="instanceId") String var3) throws InvalidUserPass, InvalidRole, CloudManagerFault;

    @WebMethod
    public CloudTemplate addTemplate(@WebParam(name="roleId") String var1, @WebParam(name="request") CreateTemplateRequest var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeTemplate(@WebParam(name="roleId") String var1, @WebParam(name="templateId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudTemplate modifyTemplate(@WebParam(name="roleId") String var1, @WebParam(name="request") ModifyTemplateRequest var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudTemplate getTemplate(@WebParam(name="roleId") String var1, @WebParam(name="templateId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudTemplate> getTemplates(@WebParam(name="roleId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getTemplateScripts(@WebParam(name="roleId") String var1) throws CloudManagerFault;

    @WebMethod
    public CloudAccountResource addAccountResource(@WebParam(name="request") CreateAccountResourceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudAccountResource modifyAccountResource(@WebParam(name="request") ModifyAccountResourceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudAccountResource modifyAccountBillingDetail(@WebParam(name="request") ModifyAccountBillingDetailRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void removeAccountResource(@WebParam(name="accountResourceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudAccountResource getAccountResource(@WebParam(name="accountResourceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudAccountResource> getAllAccountResources() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudRegion> getCloudRegionsByService(@WebParam(name="cloudServiceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudService getCloudService(@WebParam(name="cloudServiceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<CloudService> getAllCloudServices() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getCloudServicesForBilling(@WebParam(name="accountResourceId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void establishAgentConnection(@WebParam(name="facilityId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<AvailableRole> getAvailableRoles() throws CloudManagerFault, InvalidUserPass, InvalidRole;
}

