/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.factory.IResourceOperatorBase;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.fault.InvalidRole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public interface IStorageOperator
extends IResourceOperatorBase {
    public void setFlags(boolean var1, boolean var2, boolean var3);

    public CloudStorage createStorage(CreateStorageRequest var1) throws CloudManagerFault;

    public CloudStorageBackup createStorageBackup(CreateStorageBackupRequest var1) throws CloudManagerFault;

    public CloudStorage restoreStorage(RestoreStorageRequest var1) throws CloudManagerFault;

    public void removeStorage(String var1) throws CloudManagerFault, InvalidRole;

    public void removeStorageBackup(String var1) throws CloudManagerFault;

    public UpdateResult updateStorage(String var1) throws CloudManagerFault, InvalidRole;

    public UpdateAllResult updateAllStorage() throws CloudManagerFault, InvalidRole;

    public void attachStorage(String var1, String var2, String var3) throws CloudManagerFault, InvalidRole;

    public void detachStorage(String var1, String var2) throws CloudManagerFault, InvalidRole;

    public CloudStorage getStorage(String var1) throws CloudManagerFault, InvalidRole;

    public List<CloudStorage> getAllStorage() throws CloudManagerFault, InvalidRole;

    public CloudStorageBackup getStorageBackup(String var1) throws CloudManagerFault;

    public List<CloudStorageBackup> getAllStorageBuckup() throws CloudManagerFault;

    public List<CloudStorageBackup> getStorageBuckupsByStorageId(String var1) throws CloudManagerFault;

    public List<Snapshot> getSnapshotsWithFilter(List<Filter> var1) throws CloudManagerFault, InvalidRole;

    public void updateAllStorageBackup() throws CloudManagerFault, InvalidRole;

    public static class UpdateResult {
        public final String coudId;
        public final IResourceManagement.Storage stroage;
        public final CloudStorageDao cloudStorage;

        public UpdateResult(String coudId, IResourceManagement.Storage stroage, CloudStorageDao cloudStorage) {
            this.coudId = coudId;
            this.stroage = stroage;
            this.cloudStorage = cloudStorage;
        }

        public CloudStorage getCloudStorage() {
            if (this.cloudStorage != null) {
                if (this.stroage != null) {
                    return new CloudStorage(this.cloudStorage, this.stroage, HinemosUtil.getFacilityName((String)this.cloudStorage.getFacilityId()));
                }
                return new CloudStorage(this.cloudStorage, HinemosUtil.getFacilityName((String)this.cloudStorage.getFacilityId()));
            }
            return null;
        }
    }

    public static class UpdateAllResult {
        public final List<StorageMapping> both;
        public final List<StorageMapping> onlyAws;
        public final List<CloudStorageDao> onlyCloud;

        public UpdateAllResult(List<StorageMapping> both, List<StorageMapping> onlyAws, List<CloudStorageDao> onlyCloud) {
            this.both = Collections.unmodifiableList(both);
            this.onlyAws = Collections.unmodifiableList(onlyAws);
            this.onlyCloud = Collections.unmodifiableList(onlyCloud);
        }

        public List<CloudStorage> getCloudStorages() {
            Logger logger = Logger.getLogger(UpdateAllResult.class);
            ArrayList<CloudStorage> cloudStorages = new ArrayList<CloudStorage>();
            for (StorageMapping mapping : this.both) {
                cloudStorages.add(new CloudStorage(mapping.cloudStorage, mapping.storage, HinemosUtil.getFacilityName((String)mapping.cloudStorage.getFacilityId())));
                logger.debug((Object)("Both : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId()));
            }
            for (StorageMapping mapping : this.onlyAws) {
                cloudStorages.add(new CloudStorage(mapping.cloudStorage, mapping.storage, HinemosUtil.getFacilityName((String)mapping.cloudStorage.getFacilityId())));
                logger.debug((Object)("AWS : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId()));
            }
            for (CloudStorageDao cs : this.onlyCloud) {
                cloudStorages.add(new CloudStorage(cs, HinemosUtil.getFacilityName((String)cs.getFacilityId())));
                logger.debug((Object)("Cloud : facilityId=" + cs.getFacilityId() + ", storageId=" + cs.getStorageId()));
            }
            return cloudStorages;
        }

        public static class StorageMapping {
            public IResourceManagement.Storage storage;
            public CloudStorageDao cloudStorage;

            public StorageMapping(IResourceManagement.Storage storage, CloudStorageDao cloudStorage) {
                this.storage = storage;
                this.cloudStorage = cloudStorage;
            }
        }
    }
}

