/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;
import org.apache.log4j.Logger;

public enum CloudPropertyConstants implements PropertyContract
{
    billingalarm_servicename("hinemos.cloud.billingalarm.servicename", "Total,AmazonEC2,AmazonS3,AmazonSimpleDB,AmazonSNS,AWSDataTransfer"),
    billingalarm_notify_interval("hinemos.cloud.billing.notify.interval", "0 15 * * * ?"),
    autoupdate_node("hinemos.cloud.autoupdate.node", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_mount("hinemos.cloud.autoupdate.mount", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_instance("hinemos.cloud.autoupdate.instance", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_storage("hinemos.cloud.autoupdate.storage", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_backup("hinemos.cloud.autoupdate.backup", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_interval("hinemos.cloud.autoupdate.interval", "0 */10 * * * ?"),
    internal_thread_admin_user("hinemos.cloud.internal_thread.admin.user", "hinemos"),
    autoregist_scope_relation("hinemos.cloud.autoregist.scope.relation", "on", (PropValidator)PropValidator.switchValidator),
    autoregist_instance("hinemos.cloud.autoregist.instance", "on", (PropValidator)PropValidator.switchValidator),
    autoregist_storage("hinemos.cloud.autoregist.storage", "on", (PropValidator)PropValidator.switchValidator),
    password_crypt_key("hinemos.cloud.password.crypt.key", "hinemos"),
    registcheck_interval("hinemos.cloud.registcheck.interval", String.valueOf(10000), PropValidator.intValidator),
    registcheck_count("hinemos.cloud.registcheck.count", String.valueOf(30), PropValidator.intValidator),
    agent_connection_interval("agent.connection.interval", String.valueOf(10000), PropValidator.intValidator),
    agent_connection_count("agent.connection.count", String.valueOf(30), PropValidator.intValidator),
    templatejob_endcheck_interval("hinemos.cloud.templatejob.endcheck.interval", String.valueOf(10000), PropValidator.intValidator),
    templatejob_endcheck_count("hinemos.cloud.templatejob.endcheck.count", String.valueOf(30), PropValidator.intValidator),
    templatejob_script_file_dir("hinemos.cloud.templatejob.scriptfile.dir", "var/cloud/");

    public final String id;
    public final String value;
    public final PropValidator validator;

    private CloudPropertyConstants(String id, String value) {
        this.id = id;
        this.value = value;
        this.validator = null;
    }

    private CloudPropertyConstants(String id, String value, PropValidator validator) {
        this.id = id;
        this.value = value;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.value);
        if (this.validator != null) {
            try {
                this.validator.validate(prop);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(CloudPropertyConstants.class);
                logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.value + ")."));
                prop = this.value;
            }
        }
        return prop;
    }

    public boolean match(String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.value;
    }
}

