/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.bean.CloudRequest;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(value=CloudUserValidator.class)
public class CreateAccountResourceRequest
extends CloudRequest {
    private String accountResourceId;
    private String accountResourceName;
    private String cloudServiceId;
    private String description;
    private Account account;

    @ElementId(value="accountResourceId")
    @Identity
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    public void setAccountResourceId(String accountResourceId) {
        this.accountResourceId = accountResourceId;
    }

    @ElementId(value="accountResourceName")
    @Size(max=128)
    @NotNull
    public String getAccountResourceName() {
        return this.accountResourceName;
    }

    public void setAccountResourceName(String accountResourceName) {
        this.accountResourceName = accountResourceName;
    }

    @ElementId(value="cloudServiceId")
    @Identity
    public String getCloudServiceId() {
        return this.cloudServiceId;
    }

    public void setCloudServiceId(String cloudServiceId) {
        this.cloudServiceId = cloudServiceId;
    }

    @ElementId(value="description")
    @Size(max=256)
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ElementId(value="accountResourceAccount")
    @NotNull
    @Into
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public static class Account {
        private String cloudUserId;
        private String cloudUserName;
        private String description;
        private String accessKey;
        private String secretKey;
        private String roleId;

        @ElementId(value="cloudUserId")
        @Identity
        public String getCloudUserId() {
            return this.cloudUserId;
        }

        public void setCloudUserId(String cloudUserId) {
            this.cloudUserId = cloudUserId;
        }

        @ElementId(value="cloudUserName")
        @Size(max=128)
        @NotNull
        public String getCloudUserName() {
            return this.cloudUserName;
        }

        public void setCloudUserName(String cloudUserName) {
            this.cloudUserName = cloudUserName;
        }

        @ElementId(value="description")
        @Size(max=256)
        @NotNull
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @ElementId(value="roleId")
        @Identity
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }
    }

    public static class CloudUserValidator
    implements CustomEntityValidator<CreateAccountResourceRequest>,
    ValidationConstants {
        public void validate(CreateAccountResourceRequest entity, String group, IMessagesHolder messages, EntityValidator.EntityValidationContext context) throws ValidationFault {
            try {
                IUserManagement um = (IUserManagement)ObjectRegistryService.registry().get(IUserManagement.class, (Object)entity.getCloudServiceId());
                um.setCredential(new IUserManagement.Credential(entity.getAccount().getAccessKey(), entity.getAccount().getSecretKey()));
                um.getCurrentUser();
            }
            catch (CloudManagerFault e) {
                throw new ValidationFault(e.getMessage(), e.getErrorCode(), (Throwable)((Object)e));
            }
        }
    }
}

