/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.xml.bind.annotation.XmlTransient;

public class CloudUser
implements Serializable {
    private static final long serialVersionUID = -9161813048730684001L;
    private CloudUserDao dao;
    private String accountResourceId;

    public CloudUser() {
        this.dao = new CloudUserDao();
    }

    public CloudUser(CloudUserDao dao) {
        this.dao = new CloudUserDao(dao);
        this.accountResourceId = dao.getAccountResource().getAccountResourceId();
    }

    @Identity
    public String getCloudUserId() {
        return this.dao.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this.dao.setCloudUserId(cloudUserId);
    }

    @Size(max=128)
    @NotNull(groups={"creation"})
    public String getCloudUserName() {
        return this.dao.getCloudUserName();
    }

    public void setCloudUserName(String cloudUserName) {
        this.dao.setCloudUserName(cloudUserName);
    }

    @NotNull(groups={"creation"})
    public String getSecretKey() {
        return this.dao.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.dao.setSecretKey(secretKey);
    }

    @NotNull(groups={"creation"})
    public String getAccessKey() {
        return this.dao.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.dao.setAccessKey(accessKey);
    }

    @Identity(groups={"creation"})
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    public void setAccountResourceId(String accountResourceId) {
        this.accountResourceId = accountResourceId;
    }

    @Size(max=256)
    @NotNull
    public String getDescription() {
        return this.dao.getDescription();
    }

    public void setDescription(String description) {
        this.dao.setDescription(description);
    }

    @NotNull(groups={"creation"})
    public CloudUserDao.CloudUserType getCloudUserType() {
        if (this.dao.getCloudUserType() != null) {
            return CloudUserDao.CloudUserType.valueOf((String)this.dao.getCloudUserType().name());
        }
        return null;
    }

    public void setCloudUserType(CloudUserDao.CloudUserType cloudUserType) {
        if (cloudUserType != null) {
            this.dao.setCloudUserType(CloudUserDao.CloudUserType.valueOf((String)cloudUserType.name()));
        } else {
            this.dao.setCloudUserType(null);
        }
    }

    @Identity(groups={"creation"})
    public String getRoleId() {
        return this.dao.getRoleId();
    }

    public void setRoleId(String roleId) {
        this.dao.setRoleId(roleId);
    }

    @ReadOnly
    public Long getRegDate() {
        return this.dao.getRegDate() != null ? Long.valueOf(this.dao.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        if (regDate == null) {
            this.dao.setRegDate(null);
        } else {
            this.dao.setRegDate(new Timestamp(regDate));
        }
    }

    @ReadOnly
    public Long getUpdateDate() {
        return this.dao.getUpdateDate() != null ? Long.valueOf(this.dao.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        if (updateDate == null) {
            this.dao.setUpdateDate(null);
        } else {
            this.dao.setUpdateDate(new Timestamp(updateDate));
        }
    }

    @ReadOnly
    public String getRegUser() {
        return this.dao.getRegUser();
    }

    public void setRegUser(String regUser) {
        this.dao.setRegUser(regUser);
    }

    @ReadOnly
    public String getUpdateUser() {
        return this.dao.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        this.dao.setUpdateUser(updateUser);
    }

    @XmlTransient
    public CloudUserDao getTableData() {
        return this.dao;
    }
}

