/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimingInfo {
    private final long startTime;
    private long endTime;
    private final Map<String, List<TimingInfo>> subMeasurementsByName = new HashMap<String, List<TimingInfo>>();
    private final Map<String, Number> countersByName = new HashMap<String, Number>();

    public TimingInfo() {
        this(System.currentTimeMillis(), -1L);
    }

    public TimingInfo(long startTime) {
        this(startTime, -1L);
    }

    public TimingInfo(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getTimeTakenMillis() {
        return (double)TimeUnit.NANOSECONDS.toMicros(this.endTime - this.startTime) / 1000.0;
    }

    public String toString() {
        return String.valueOf(this.getTimeTakenMillis());
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void addSubMeasurement(String subMeasurementName, TimingInfo timingInfo) {
        List<TimingInfo> timings = this.subMeasurementsByName.get(subMeasurementName);
        if (timings == null) {
            timings = new ArrayList<TimingInfo>();
            this.subMeasurementsByName.put(subMeasurementName, timings);
        }
        timings.add(timingInfo);
    }

    public TimingInfo getSubMeasurement(String subMeasurementName) {
        return this.getSubMeasurement(subMeasurementName, 0);
    }

    public TimingInfo getSubMeasurement(String subMesurementName, int index) {
        List<TimingInfo> timings = this.subMeasurementsByName.get(subMesurementName);
        if (index < 0 || timings == null || timings.size() == 0 || index >= timings.size()) {
            return null;
        }
        return timings.get(index);
    }

    public TimingInfo getLastSubMeasurement(String subMeasurementName) {
        if (this.subMeasurementsByName == null || this.subMeasurementsByName.size() == 0) {
            return null;
        }
        return this.getSubMeasurement(subMeasurementName, this.subMeasurementsByName.size() - 1);
    }

    public List<TimingInfo> getAllSubMeasurements(String subMeasurementName) {
        return this.subMeasurementsByName.get(subMeasurementName);
    }

    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return this.subMeasurementsByName;
    }

    public Number getCounter(String key) {
        return this.countersByName.get(key);
    }

    public Map<String, Number> getAllCounters() {
        return this.countersByName;
    }

    public void setCounter(String key, long count) {
        this.countersByName.put(key, count);
    }

    public void incrementCounter(String key) {
        int count = 0;
        Number counter = this.getCounter(key);
        if (counter != null) {
            count = counter.intValue();
        }
        this.setCounter(key, ++count);
    }
}

