/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationResult;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksResult;
import com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResult;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RebuildEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RequestEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RestartAppServerRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.S3SubscriptionRequiredExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SourceBundleDeletionExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SwapEnvironmentCNAMEsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationVersionsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyBucketsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyConfigurationTemplatesExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyEnvironmentsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticBeanstalkClient
extends AmazonWebServiceClient
implements AWSElasticBeanstalk {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private QueryStringSigner signer;

    public AWSElasticBeanstalkClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TooManyEnvironmentsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new S3SubscriptionRequiredExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationVersionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SourceBundleDeletionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyConfigurationTemplatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyBucketsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticbeanstalk.us-east-1.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticbeanstalk/request.handlers"));
    }

    @Override
    public CheckDNSAvailabilityResult checkDNSAvailability(CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) throws AmazonServiceException, AmazonClientException {
        Request<CheckDNSAvailabilityRequest> request = new CheckDNSAvailabilityRequestMarshaller().marshall(checkDNSAvailabilityRequest);
        return this.invoke(request, new CheckDNSAvailabilityResultStaxUnmarshaller());
    }

    @Override
    public DescribeConfigurationOptionsResult describeConfigurationOptions(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeConfigurationOptionsRequest> request = new DescribeConfigurationOptionsRequestMarshaller().marshall(describeConfigurationOptionsRequest);
        return this.invoke(request, new DescribeConfigurationOptionsResultStaxUnmarshaller());
    }

    @Override
    public void deleteConfigurationTemplate(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteConfigurationTemplateRequest> request = new DeleteConfigurationTemplateRequestMarshaller().marshall(deleteConfigurationTemplateRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateEnvironmentResult createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateEnvironmentRequest> request = new CreateEnvironmentRequestMarshaller().marshall(createEnvironmentRequest);
        return this.invoke(request, new CreateEnvironmentResultStaxUnmarshaller());
    }

    @Override
    public CreateStorageLocationResult createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateStorageLocationRequest> request = new CreateStorageLocationRequestMarshaller().marshall(createStorageLocationRequest);
        return this.invoke(request, new CreateStorageLocationResultStaxUnmarshaller());
    }

    @Override
    public void requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) throws AmazonServiceException, AmazonClientException {
        Request<RequestEnvironmentInfoRequest> request = new RequestEnvironmentInfoRequestMarshaller().marshall(requestEnvironmentInfoRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateApplicationVersionResult createApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateApplicationVersionRequest> request = new CreateApplicationVersionRequestMarshaller().marshall(createApplicationVersionRequest);
        return this.invoke(request, new CreateApplicationVersionResultStaxUnmarshaller());
    }

    @Override
    public void deleteApplicationVersion(DeleteApplicationVersionRequest deleteApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteApplicationVersionRequest> request = new DeleteApplicationVersionRequestMarshaller().marshall(deleteApplicationVersionRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeApplicationVersionsRequest> request = new DescribeApplicationVersionsRequestMarshaller().marshall(describeApplicationVersionsRequest);
        return this.invoke(request, new DescribeApplicationVersionsResultStaxUnmarshaller());
    }

    @Override
    public void deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteApplicationRequest> request = new DeleteApplicationRequestMarshaller().marshall(deleteApplicationRequest);
        this.invoke(request, null);
    }

    @Override
    public UpdateApplicationVersionResult updateApplicationVersion(UpdateApplicationVersionRequest updateApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateApplicationVersionRequest> request = new UpdateApplicationVersionRequestMarshaller().marshall(updateApplicationVersionRequest);
        return this.invoke(request, new UpdateApplicationVersionResultStaxUnmarshaller());
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest createApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateApplicationRequest> request = new CreateApplicationRequestMarshaller().marshall(createApplicationRequest);
        return this.invoke(request, new CreateApplicationResultStaxUnmarshaller());
    }

    @Override
    public void swapEnvironmentCNAMEs(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) throws AmazonServiceException, AmazonClientException {
        Request<SwapEnvironmentCNAMEsRequest> request = new SwapEnvironmentCNAMEsRequestMarshaller().marshall(swapEnvironmentCNAMEsRequest);
        this.invoke(request, null);
    }

    @Override
    public UpdateConfigurationTemplateResult updateConfigurationTemplate(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateConfigurationTemplateRequest> request = new UpdateConfigurationTemplateRequestMarshaller().marshall(updateConfigurationTemplateRequest);
        return this.invoke(request, new UpdateConfigurationTemplateResultStaxUnmarshaller());
    }

    @Override
    public RetrieveEnvironmentInfoResult retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) throws AmazonServiceException, AmazonClientException {
        Request<RetrieveEnvironmentInfoRequest> request = new RetrieveEnvironmentInfoRequestMarshaller().marshall(retrieveEnvironmentInfoRequest);
        return this.invoke(request, new RetrieveEnvironmentInfoResultStaxUnmarshaller());
    }

    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks(ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListAvailableSolutionStacksRequest> request = new ListAvailableSolutionStacksRequestMarshaller().marshall(listAvailableSolutionStacksRequest);
        return this.invoke(request, new ListAvailableSolutionStacksResultStaxUnmarshaller());
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest updateApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateApplicationRequest> request = new UpdateApplicationRequestMarshaller().marshall(updateApplicationRequest);
        return this.invoke(request, new UpdateApplicationResultStaxUnmarshaller());
    }

    @Override
    public DescribeEnvironmentsResult describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEnvironmentsRequest> request = new DescribeEnvironmentsRequestMarshaller().marshall(describeEnvironmentsRequest);
        return this.invoke(request, new DescribeEnvironmentsResultStaxUnmarshaller());
    }

    @Override
    public DescribeEnvironmentResourcesResult describeEnvironmentResources(DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEnvironmentResourcesRequest> request = new DescribeEnvironmentResourcesRequestMarshaller().marshall(describeEnvironmentResourcesRequest);
        return this.invoke(request, new DescribeEnvironmentResourcesResultStaxUnmarshaller());
    }

    @Override
    public TerminateEnvironmentResult terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateEnvironmentRequest> request = new TerminateEnvironmentRequestMarshaller().marshall(terminateEnvironmentRequest);
        return this.invoke(request, new TerminateEnvironmentResultStaxUnmarshaller());
    }

    @Override
    public ValidateConfigurationSettingsResult validateConfigurationSettings(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ValidateConfigurationSettingsRequest> request = new ValidateConfigurationSettingsRequestMarshaller().marshall(validateConfigurationSettingsRequest);
        return this.invoke(request, new ValidateConfigurationSettingsResultStaxUnmarshaller());
    }

    @Override
    public void restartAppServer(RestartAppServerRequest restartAppServerRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestartAppServerRequest> request = new RestartAppServerRequestMarshaller().marshall(restartAppServerRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteEnvironmentConfigurationRequest> request = new DeleteEnvironmentConfigurationRequestMarshaller().marshall(deleteEnvironmentConfigurationRequest);
        this.invoke(request, null);
    }

    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateEnvironmentRequest> request = new UpdateEnvironmentRequestMarshaller().marshall(updateEnvironmentRequest);
        return this.invoke(request, new UpdateEnvironmentResultStaxUnmarshaller());
    }

    @Override
    public CreateConfigurationTemplateResult createConfigurationTemplate(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateConfigurationTemplateRequest> request = new CreateConfigurationTemplateRequestMarshaller().marshall(createConfigurationTemplateRequest);
        return this.invoke(request, new CreateConfigurationTemplateResultStaxUnmarshaller());
    }

    @Override
    public DescribeConfigurationSettingsResult describeConfigurationSettings(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeConfigurationSettingsRequest> request = new DescribeConfigurationSettingsRequestMarshaller().marshall(describeConfigurationSettingsRequest);
        return this.invoke(request, new DescribeConfigurationSettingsResultStaxUnmarshaller());
    }

    @Override
    public DescribeApplicationsResult describeApplications(DescribeApplicationsRequest describeApplicationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeApplicationsRequest> request = new DescribeApplicationsRequestMarshaller().marshall(describeApplicationsRequest);
        return this.invoke(request, new DescribeApplicationsResultStaxUnmarshaller());
    }

    @Override
    public void rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        Request<RebuildEnvironmentRequest> request = new RebuildEnvironmentRequestMarshaller().marshall(rebuildEnvironmentRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventsRequest> request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
        return this.invoke(request, new DescribeEventsResultStaxUnmarshaller());
    }

    @Override
    public CreateStorageLocationResult createStorageLocation() throws AmazonServiceException, AmazonClientException {
        return this.createStorageLocation(new CreateStorageLocationRequest());
    }

    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeApplicationVersions(new DescribeApplicationVersionsRequest());
    }

    @Override
    public void swapEnvironmentCNAMEs() throws AmazonServiceException, AmazonClientException {
        this.swapEnvironmentCNAMEs(new SwapEnvironmentCNAMEsRequest());
    }

    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks() throws AmazonServiceException, AmazonClientException {
        return this.listAvailableSolutionStacks(new ListAvailableSolutionStacksRequest());
    }

    @Override
    public DescribeEnvironmentsResult describeEnvironments() throws AmazonServiceException, AmazonClientException {
        return this.describeEnvironments(new DescribeEnvironmentsRequest());
    }

    @Override
    public DescribeApplicationsResult describeApplications() throws AmazonServiceException, AmazonClientException {
        return this.describeApplications(new DescribeApplicationsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

