/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.persistence;

import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.commons.util.JpaTransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.apache.log4j.Logger;

public class StdEntityManagerEx
implements EntityManagerEx {
    private EntityManager entityManager;

    public StdEntityManagerEx() {
        JpaTransactionManager tm = new JpaTransactionManager();
        this.entityManager = tm.getEntityManager();
    }

    public StdEntityManagerEx(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public StdEntityManagerEx(JpaTransactionManager tm) {
        this.entityManager = tm.getEntityManager();
    }

    @Override
    public <T> List<T> findAll(Class<T> type) {
        Logger logger = Logger.getLogger(StdEntityManagerEx.class);
        logger.debug((Object)"findAll() start");
        try {
            Query q = this.entityManager.createQuery("select c from " + type.getSimpleName() + " c");
            return q.getResultList();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> List<T> findByFilter(Class<T> type, Filter ... filters) {
        Logger logger = Logger.getLogger(StdEntityManagerEx.class);
        logger.debug((Object)"findByFilter() start");
        StringBuilder sb = new StringBuilder();
        sb.append("select c from ");
        sb.append(type.getSimpleName());
        sb.append(" c where ");
        boolean subsequent = false;
        for (Filter f : filters) {
            if (subsequent) {
                sb.append(" and ");
            }
            if (f.getValues().size() > 1) {
                sb.append('(');
            }
            boolean subsequent2 = false;
            for (String v : f.getValues()) {
                if (subsequent2) {
                    sb.append(" or ");
                }
                sb.append("c.").append(f.getName()).append(" like ").append("'" + v + "'");
                subsequent2 = true;
            }
            if (f.getValues().size() > 1) {
                sb.append(')');
            }
            subsequent = true;
        }
        Query q = this.entityManager.createQuery(sb.toString());
        List result = q.getResultList();
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void persist(Object entity) {
        this.entityManager.persist(entity);
    }

    @Override
    public void persist(IDHolder entity) {
        Object managed = this.find(entity.getClass(), entity.getId());
        if (managed != null) {
            throw new EntityExistsException("{" + entity.getClass().getSimpleName() + ", " + entity.getId().toString() + "}");
        }
        this.entityManager.persist((Object)entity);
    }

    public <T> T merge(T entity) {
        return (T)this.entityManager.merge(entity);
    }

    public void remove(Object entity) {
        this.entityManager.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.entityManager.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.entityManager.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.entityManager.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.entityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.entityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public void detach(Object entity) {
        this.entityManager.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.entityManager.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.entityManager.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.entityManager.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.entityManager.getProperties();
    }

    public Query createQuery(String qlString) {
        return this.entityManager.createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.entityManager.createQuery(criteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.entityManager.createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        return this.entityManager.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.entityManager.createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.entityManager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        this.entityManager.joinTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManager.unwrap(cls);
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public void close() {
        this.entityManager.close();
    }

    public boolean isOpen() {
        return this.entityManager.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.entityManager.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManager.getMetamodel();
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.entityManager.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.entityManager.createQuery(deleteQuery);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.entityManager.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.entityManager.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.entityManager.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.entityManager.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public boolean isJoinedToTransaction() {
        return this.entityManager.isJoinedToTransaction();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.entityManager.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.entityManager.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.entityManager.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.entityManager.getEntityGraphs(entityClass);
    }
}

