/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.ICloudStorage.RegistStateType;
import com.clustercontrol.util.Messages;

public class DetachStorageFromStorageAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DetachStorageFromStorageAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgDetachStorageConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.detach"});
	private String msgDetachStorageResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.detach"});

	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			ICloudStorage storage = (ICloudStorage)iter.next();
			if (storage.getStorageAttachment() == null || RegistStateType.deleted.name().equals(storage.getRegistState())) {
				return false;
			}
			break;
		}
		
		return true;
	}

	@Override
	protected void invoke(IAction action) throws InvocationException {
		StringBuffer sb = new StringBuffer();
		
		Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
		int i = 0;
		while (iter.hasNext()) {
			sb.append(((ICloudStorage)iter.next()).getStorageId());
			if(iter.hasNext()) sb.append(", ");
			i++;
			if(i > 10){
				sb.append("\n");
				i = 0;
			}
		}
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgDetachStorageConfirm+"\n"+sb)){

			iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			while (iter.hasNext()) {
				ICloudStorage vol = (ICloudStorage)iter.next();
				vol.detach();
				break;
			}
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgDetachStorageResult);
		}
	}
}