/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class CacheService {
	private Map<Object, Map<Class<?>, Object>> map = new WeakHashMap<Object, Map<Class<?>, Object>>();
	private static CacheService singleton;
	
	private CacheService() {
	}
	
	public synchronized <T> void put(Object key, Class<T> type, T value) {
		Map<Class<?>, Object> valueMap = map.get(key);
		if (valueMap == null) {
			valueMap = new HashMap<Class<?>, Object>();
			map.put(key, valueMap);
		}
		valueMap.put(type, value);
	}

	@SuppressWarnings("unchecked")
	public synchronized <T> T get(Object key, Class<T> type) {
		Map<Class<?>, Object> valueMap = map.get(key);
		if (valueMap == null) {
			return null;
		}
		T result = (T)valueMap.get(type);
		valueMap.remove(type);
		return result;
	}

	public synchronized Object remove(Object key) {
		return map.remove(key);
	}

	public synchronized static CacheService getSingleton() {
		if (singleton == null) {
			singleton = new CacheService();
		}
		return singleton;
	}
}
