/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Combo;

public class CreateTemplateAction
extends AbstractViewAction {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateTemplateConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.create"});
    private String msgCreateTemplateResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.create"});
    private CloudResourceProvider provider;
    private IAccountResource.IRegion region;

    protected void invoke(IAction action) throws InvocationException {
        final IAccountResource accountResource = ((TemplatesView)this.viewPart).getAccountResource();
        this.provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
        if (((TemplatesView)this.viewPart).getActiveRegion() != null) {
            this.region = ((TemplatesView)this.viewPart).getActiveRegion();
        }
        CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
                private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
                private List<TemplateJobUtil.TemplateJobnet> templateJobs;
                private IAccountResource.IRegion region;
                {
                    try {
                        this.templateJobs = TemplateJobUtil.getTemplateJobList((String)accountResource.getAccountResourceId(), (Boolean)true);
                    }
                    catch (InvalidRole_Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        this.templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
                    }
                    this.region = CreateTemplateAction.this.region;
                }

                @Override
                public void setupRegion(Combo region) {
                    for (String regionName : CreateTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = this.messages.getString(regionName);
                        region.add(regionLocaleName);
                        region.setData(regionLocaleName, (Object)regionName);
                    }
                    if (this.region != null) {
                        String regionLocaleName = this.messages.getString(this.region.getRegionName());
                        region.select(region.indexOf(regionLocaleName));
                    } else {
                        region.select(0);
                    }
                }

                @Override
                public void setupLaunchJobId(Combo launchJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        launchJobId.add(jobName);
                        launchJobId.setData(jobName, (Object)jobId);
                    }
                }

                @Override
                public void setupStartJobId(Combo startJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        startJobId.add(jobName);
                        startJobId.setData(jobName, (Object)jobId);
                    }
                }

                @Override
                public void setupStopJobId(Combo stopJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        stopJobId.add(jobName);
                        stopJobId.setData(jobName, (Object)jobId);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateTemplateConfirm)) {
                ICloudTemplateManager templateManager = accountResource.getCloudTemplateManager();
                templateManager.createCloudTemplate(dialog.getOutput());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateTemplateResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (((TemplatesView)this.viewPart).getAccountResource() != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

