package com.clustercontrol.performance.monitor.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.util.List;


/**
 * The persistent class for the cc_collector_calc_method_mst database table.
 * 
 */
@Entity
@Table(name="cc_collector_calc_method_mst")
@Cacheable(true)
public class CollectorCalcMethodMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String calcMethod;
	private String className;
	private String expression;
	private List<CollectorItemCalcMethodMstEntity> collectorItemCalcMethodMstEntities;

	@Deprecated
	public CollectorCalcMethodMstEntity() {
	}

	public CollectorCalcMethodMstEntity(String calcMethod) {
		this.setCalcMethod(calcMethod);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	@Column(name="calc_method")
	public String getCalcMethod() {
		return this.calcMethod;
	}

	public void setCalcMethod(String calcMethod) {
		this.calcMethod = calcMethod;
	}


	@Column(name="class_name")
	public String getClassName() {
		return this.className;
	}

	public void setClassName(String className) {
		this.className = className;
	}


	public String getExpression() {
		return this.expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}


	//bi-directional many-to-one association to CollectorItemCalcMethodMstEntity
	@OneToMany(mappedBy="collectorCalcMethodMstEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<CollectorItemCalcMethodMstEntity> getCollectorItemCalcMethodMstEntities() {
		return this.collectorItemCalcMethodMstEntities;
	}

	public void setCollectorItemCalcMethodMstEntities(List<CollectorItemCalcMethodMstEntity> collectorItemCalcMethodMstEntities) {
		this.collectorItemCalcMethodMstEntities = collectorItemCalcMethodMstEntities;
	}

}