package com.clustercontrol.monitor.run.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_monitor_trap_value_info database table.
 * 
 */
@Entity
@Table(name="cc_monitor_trap_value_info")
@Cacheable(true)
public class MonitorTrapValueInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private MonitorTrapValueInfoEntityPK id;
	private String descr;
	private String logmsg;
	private Integer priority;
	private Integer validFlg;
	private MonitorInfoEntity monitorInfoEntity;

	@Deprecated
	public MonitorTrapValueInfoEntity() {
	}

	public MonitorTrapValueInfoEntity(MonitorTrapValueInfoEntityPK pk,
			MonitorInfoEntity monitorInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToMonitorInfoEntity(monitorInfoEntity);
	}

	public MonitorTrapValueInfoEntity(
			MonitorInfoEntity monitorInfoEntity,
			String mib,
			String trapOid,
			Integer genericId,
			Integer specificId,
			String uei) {
		this(new MonitorTrapValueInfoEntityPK(
				monitorInfoEntity.getMonitorId(),
				mib,
				trapOid,
				genericId,
				specificId,
				uei), monitorInfoEntity);
	}


	@EmbeddedId
	public MonitorTrapValueInfoEntityPK getId() {
		return this.id;
	}

	public void setId(MonitorTrapValueInfoEntityPK id) {
		this.id = id;
	}


	public String getDescr() {
		return this.descr;
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}


	public String getLogmsg() {
		return this.logmsg;
	}

	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}


	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}


	@Column(name="valid_flg")
	public Integer getValidFlg() {
		return this.validFlg;
	}

	public void setValidFlg(Integer validFlg) {
		this.validFlg = validFlg;
	}


	//bi-directional many-to-one association to MonitorInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="monitor_id", insertable=false, updatable=false)
	public MonitorInfoEntity getMonitorInfoEntity() {
		return this.monitorInfoEntity;
	}

	@Deprecated
	public void setMonitorInfoEntity(MonitorInfoEntity monitorInfoEntity) {
		this.monitorInfoEntity = monitorInfoEntity;
	}

	/**
	 * MonitorInfoEntityオブジェクト参照設定<BR>
	 * 
	 * MonitorInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToMonitorInfoEntity(MonitorInfoEntity monitorInfoEntity) {
		this.setMonitorInfoEntity(monitorInfoEntity);
		if (monitorInfoEntity != null) {
			List<MonitorTrapValueInfoEntity> list = monitorInfoEntity.getMonitorTrapValueInfoEntities();
			if (list == null) {
				list = new ArrayList<MonitorTrapValueInfoEntity>();
			} else {
				for(MonitorTrapValueInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			monitorInfoEntity.setMonitorTrapValueInfoEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// MonitorInfoEntity
		if (this.monitorInfoEntity != null) {
			List<MonitorTrapValueInfoEntity> list = this.monitorInfoEntity.getMonitorTrapValueInfoEntities();
			if (list != null) {
				Iterator<MonitorTrapValueInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					MonitorTrapValueInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}