package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_crun_cmd_mst database table.
 * 
 */
@Entity
@Table(name="cc_crun_cmd_mst")
@Cacheable(true)
public class CrunCmdMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String commandId;
	private String command;
	private Integer commandType;
	private String nameId;
	private Integer orderNo;
	private CrunTypeMstEntity crunTypeMstEntity;
	private List<CrunCmdParamMstEntity> crunCmdParamMstEntities;
	private List<CrunEndMstEntity> crunEndMstEntities;

	@Deprecated
	public CrunCmdMstEntity() {
	}

	public CrunCmdMstEntity(String commandId, CrunTypeMstEntity crunTypeMstEntity) {
		this.setCommandId(commandId);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunTypeMstEntity(crunTypeMstEntity);
	}

	@Id
	@Column(name="command_id")
	public String getCommandId() {
		return this.commandId;
	}

	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}


	public String getCommand() {
		return this.command;
	}

	public void setCommand(String command) {
		this.command = command;
	}


	@Column(name="command_type")
	public Integer getCommandType() {
		return this.commandType;
	}

	public void setCommandType(Integer commandType) {
		this.commandType = commandType;
	}


	@Column(name="name_id")
	public String getNameId() {
		return this.nameId;
	}

	public void setNameId(String nameId) {
		this.nameId = nameId;
	}


	@Column(name="order_no")
	public Integer getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}


	//bi-directional many-to-one association to CrunTypeMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="type_id")
	public CrunTypeMstEntity getCrunTypeMstEntity() {
		return this.crunTypeMstEntity;
	}

	@Deprecated
	public void setCrunTypeMstEntity(CrunTypeMstEntity crunTypeMstEntity) {
		this.crunTypeMstEntity = crunTypeMstEntity;
	}

	/**
	 * CrunTypeMstEntityオブジェクト参照設定<BR>
	 * 
	 * CrunTypeMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunTypeMstEntity(CrunTypeMstEntity crunTypeMstEntity) {
		this.setCrunTypeMstEntity(crunTypeMstEntity);
		if (crunTypeMstEntity != null) {
			List<CrunCmdMstEntity> list = crunTypeMstEntity.getCrunCmdMstEntities();
			if (list == null) {
				list = new ArrayList<CrunCmdMstEntity>();
			} else {
				for(CrunCmdMstEntity entity : list){
					if (entity.getCommandId().equals(this.commandId)) {
						return;
					}
				}
			}
			list.add(this);
			crunTypeMstEntity.setCrunCmdMstEntities(list);
		}
	}

	//bi-directional many-to-one association to CrunCmdParamMstEntity
	@OneToMany(mappedBy="crunCmdMstEntity", cascade=CascadeType.ALL, orphanRemoval=true)
	public List<CrunCmdParamMstEntity> getCrunCmdParamMstEntities() {
		return this.crunCmdParamMstEntities;
	}

	public void setCrunCmdParamMstEntities(List<CrunCmdParamMstEntity> crunCmdParamMstEntities) {
		this.crunCmdParamMstEntities = crunCmdParamMstEntities;
	}


	//bi-directional many-to-one association to CrunEndMstEntity
	@OneToMany(mappedBy="crunCmdMstEntity", cascade=CascadeType.ALL, orphanRemoval=true)
	public List<CrunEndMstEntity> getCrunEndMstEntities() {
		return this.crunEndMstEntities;
	}

	public void setCrunEndMstEntities(List<CrunEndMstEntity> crunEndMstEntities) {
		this.crunEndMstEntities = crunEndMstEntities;
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunTypeMstEntity
		if (this.crunTypeMstEntity != null) {
			List<CrunCmdMstEntity> list = this.crunTypeMstEntity.getCrunCmdMstEntities();
			if (list != null) {
				Iterator<CrunCmdMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunCmdMstEntity entity = iter.next();
					if (entity.getCommandId().equals(this.commandId)){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}