/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.view.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.GetPerformanceDataSettings;
import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.performance.view.PerformanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collector.PerformanceDataSettings;

/**
 * 性能[一覧]ビューから、性能[グラフ]ビューを追加するアクションクラス
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class AddGraphAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( AddGraphAction.class );

	public static final String ID = "com.clustercontrol.performance.view.action.AddGraphAction";

	private IViewPart viewPart;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view
	 *            ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

	/**
	 * 性能[グラフ]ビューを追加します。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		// 収集中リストのビューを取得します。
		IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		PerformanceListView listView = (PerformanceListView) page
				.findView(PerformanceListView.ID);

		String monitorId = listView.getSelectedMonitorId();
		String[] args = {monitorId};


		if (monitorId != null) {
			PerformanceDataSettings perfDataSettings = GetPerformanceDataSettings.getPerformanceGraphInfo(monitorId);

			// グラフのヘッダ情報を取得成功
			if(perfDataSettings != null){
				// 収集データがなければViewを開かずに終了する
				if(perfDataSettings.getOldestDate() == null || perfDataSettings.getOldestDate() == 0){
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.collection.6"));


					return;
				}
				PerformanceGraphView.setPerformanceDataSettings(monitorId, perfDataSettings);

				try {
					PerformanceGraphView graphView = (PerformanceGraphView) page.showView(
							PerformanceGraphView.ID, monitorId,
							IWorkbenchPage.VIEW_ACTIVATE);
					graphView.setFocus();
				} catch (PartInitException e) {
					m_log.warn("run(), " + e.getMessage(), e);

					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.collection.9"));

					return;
				}
			}
			// グラフのヘッダ情報を取得失敗
			else{
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.collection.9"));

			}

		} else {
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.collection.10"));

		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action
	 * .IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}