/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.action.NotifyTableDefineNoCheckBox;
import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.notify.bean.NotifyTypeConstant;
import com.clustercontrol.notify.dialog.NotifyBasicCreateDialog;
import com.clustercontrol.notify.dialog.NotifyCommandCreateDialog;
import com.clustercontrol.notify.dialog.NotifyEventCreateDialog;
import com.clustercontrol.notify.dialog.NotifyJobCreateDialog;
import com.clustercontrol.notify.dialog.NotifyLogEscalateCreateDialog;
import com.clustercontrol.notify.dialog.NotifyMailCreateDialog;
import com.clustercontrol.notify.dialog.NotifyStatusCreateDialog;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.Messages;

/**
 * 通知[一覧]ビューのコピーアクションクラス<BR>
 * 
 * @version 4.1.0
 */
public class NotifyCopyAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( NotifyCopyAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.NotifyCopyAction";

	/** ビュー */
	private IViewPart viewPart;

	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		NotifyListView view = (NotifyListView) this.viewPart.getAdapter(NotifyListView.class);

		NotifyListComposite composite = (NotifyListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String notifyId = null;
		Integer notifyType = null;
		if(list != null && list.size() > 0){
			notifyId = (String) list.get(NotifyTableDefineNoCheckBox.NOTIFY_ID);
			notifyType = (Integer) list.get(NotifyTableDefineNoCheckBox.NOTIFY_TYPE);
		}

		Table table = composite.getTableViewer().getTable();

		// 選択アイテムがある場合に、編集ダイアログを表示する
		if(notifyId != null && notifyType != null){

			Shell shell = view.getListComposite().getShell();
			if (openDialog(shell, notifyId, notifyType) == IDialogConstants.OK_ID) {
				int selectIndex = table.getSelectionIndex();
				composite.update();
				table.setSelection(selectIndex);
			}
		}else{
			MessageDialog.openWarning(
					null,
					Messages.getString("warning"),
					Messages.getString("message.notify.8"));
		}
	}

	public int openDialog(Shell shell, String notifyId, int notifyType) {
		NotifyBasicCreateDialog dialog = null;
		if (NotifyTypeConstant.TYPE_STATUS == notifyType) {
			dialog = new NotifyStatusCreateDialog(shell, notifyId, false);
		} else if (NotifyTypeConstant.TYPE_EVENT == notifyType) {
			dialog = new NotifyEventCreateDialog(shell, notifyId, false);
		} else if (NotifyTypeConstant.TYPE_MAIL == notifyType) {
			dialog = new NotifyMailCreateDialog(shell, notifyId, false);
		} else if (NotifyTypeConstant.TYPE_JOB == notifyType) {
			dialog = new NotifyJobCreateDialog(shell, notifyId, false);
		} else if (NotifyTypeConstant.TYPE_LOG_ESCALATE == notifyType) {
			dialog = new NotifyLogEscalateCreateDialog(shell, notifyId, false);
		} else if (NotifyTypeConstant.TYPE_COMMAND == notifyType) {
			dialog = new NotifyCommandCreateDialog(shell, notifyId, false);
		}
		return dialog.open();
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
