/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.CommentEvent;
import com.clustercontrol.monitor.composite.EventListComposite;
import com.clustercontrol.monitor.dialog.EventInfoDialog;
import com.clustercontrol.monitor.view.EventView;

/**
 * 監視[イベントの詳細]ダイアログの表示を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventDetailAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.EventDetailAction";

	/** ビュー */
	private IViewPart viewPart;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * 監視[イベント]ビューの選択されたアイテムのイベント情報を取得し、
	 * 監視[イベントの詳細]ダイアログに表示します。
	 * <p>
	 * <ol>
	 * <li>監視[イベント]ビューで、選択されているアイテムを取得します。</li>
	 * <li>取得したイベント情報の監視[イベントの詳細]ダイアログを表示します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.monitor.view.EventView
	 * @see com.clustercontrol.monitor.dialog.EventInfoDialog
	 */
	@Override
	public void run(IAction action) {
		// 選択アイテムを取得します。
		EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

		EventListComposite composite =
				(EventListComposite)view.getListComposite();

		StructuredSelection selection =
				(StructuredSelection)composite.getTableViewer().getSelection();

		List list = (List)selection.getFirstElement();

		if(list != null){
			EventInfoDialog dialog =
					new EventInfoDialog(
							this.viewPart.getSite().getShell(),
							list);
			if (dialog.open() == IDialogConstants.OK_ID){
				Property event = dialog.getInputData();
				CommentEvent comment = new CommentEvent();
				comment.updateComment(event);
				view.update();

			}




		}
	}

	/**
	 * 選択を変更した際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}
