/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.maintenance.dialog.MaintenanceDialog;
import com.clustercontrol.maintenance.view.MaintenanceListView;

/**
 * メンテナンス[一覧]ビューの作成アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MaintenanceAddAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceAddAction";

	/** ビュー */
	private IViewPart viewPart;
	/**
	 * メンテナンス一覧ダイアログを表示します
	 */
	@Override
	public void run(IAction action) {
		MaintenanceDialog dialog = new MaintenanceDialog(this.viewPart.getSite()
				.getShell());
		dialog.open();
		// ビューの更新
		MaintenanceListView view = (MaintenanceListView) this.viewPart.getAdapter(MaintenanceListView.class);
		view.update();
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
