package com.clustercontrol.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.ws.access.AccessEndpointService;
import com.clustercontrol.ws.calendar.CalendarEndpointService;
import com.clustercontrol.ws.collectiverun.CollectiveRunEndpointService;
import com.clustercontrol.ws.collectmaster.PerformanceCollectMasterEndpointService;
import com.clustercontrol.ws.collector.CollectorEndpointService;
import com.clustercontrol.ws.jobmanagement.JobEndpointService;
import com.clustercontrol.ws.jobmanagement.JobMapEndpointService;
import com.clustercontrol.ws.mailtemplate.MailTemplateEndpointService;
import com.clustercontrol.ws.maintenance.MaintenanceEndpointService;
import com.clustercontrol.ws.monitor.MonitorEndpointService;
import com.clustercontrol.ws.monitor.MonitorSettingEndpointService;
import com.clustercontrol.ws.monitor.MonitorSnmpTrapEndpointService;
import com.clustercontrol.ws.nodemap.NodeMapEndpointService;
import com.clustercontrol.ws.notify.NotifyEndpointService;
import com.clustercontrol.ws.repository.RepositoryEndpointService;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class EndpointManager {

	// ログ
	private static Log m_log = LogFactory.getLog( EndpointManager.class );

	private static EndpointList endpointList;
	private final static String ACCESS = AccessEndpointService.class.getSimpleName();
	private final static String CALENDAR = CalendarEndpointService.class.getSimpleName();
	private final static String COLLECTIVE_RUN = CollectiveRunEndpointService.class.getSimpleName();
	private final static String COLLECTOR = CollectorEndpointService.class.getSimpleName();
	private final static String JOB = JobEndpointService.class.getSimpleName();
	private final static String JOBMAP = JobMapEndpointService.class.getSimpleName();
	private final static String MAIL_TEMPLATE = MailTemplateEndpointService.class.getSimpleName();
	private final static String MAINTENANCE = MaintenanceEndpointService.class.getSimpleName();
	private final static String MONITOR = MonitorEndpointService.class.getSimpleName();
	private final static String MONITOR_SETTING = MonitorSettingEndpointService.class.getSimpleName();
	private final static String MONITOR_SNMPTRAP = MonitorSnmpTrapEndpointService.class.getSimpleName();
	private final static String NODEMAP = NodeMapEndpointService.class.getSimpleName();
	private final static String NOTIFY = NotifyEndpointService.class.getSimpleName();
	private final static String REPOSITORY = RepositoryEndpointService.class.getSimpleName();
	private final static String PERFORMANCE_COLLECT_MASTER = PerformanceCollectMasterEndpointService.class.getSimpleName();

	private static String username = "";
	private static String password = "";
	public static int m_httpConnectTimeout = LoginManager.VALUE_HTTP_CONNECT_TIMEOUT;
	public static int m_httpRequestTimeout = LoginManager.VALUE_HTTP_REQUEST_TIMEOUT;

	private static class EndpointList {
		/*
		 * endpointListはマネージャ一覧を示す。
		 * これは初期化時のみ変更可能(add可能)。
		 * 
		 * lastSuccessEndpointは最後に成功したendpointを示す。
		 * endpointList.contains(lastSuccessEndpoint)は必ずtrueになる。
		 */
		private ArrayList<HashMap<String, EndpointSetting>> endpointList =
				new ArrayList<HashMap<String, EndpointSetting>>();
		private HashMap<String, EndpointSetting> lastSuccessEndpoint = null;

		private void add(HashMap<String, EndpointSetting> endpointMap) {
			if (lastSuccessEndpoint == null) {
				lastSuccessEndpoint = endpointMap;
			}
			endpointList.add(endpointMap);
		}

		private ArrayList<EndpointSetting> getList(String key) {
			ArrayList<EndpointSetting> list = new ArrayList<EndpointSetting>();
			list.add(lastSuccessEndpoint.get(key));
			for (HashMap<String, EndpointSetting> endpoint : endpointList) {
				if (!endpoint.equals(lastSuccessEndpoint)) {
					list.add(endpoint.get(key));
				}
			}
			return list;
		}

		/*
		 * 当面、使用予定なし。
		 */
		@SuppressWarnings("unused")
		@Deprecated
		private void setLastSuccess(HashMap<String, EndpointSetting> endpoint) {
			if (!endpointList.contains(endpoint)) {
				m_log.warn("setLastSuccess(), Error:!endpointList.contains(endpoint)");
			}
			lastSuccessEndpoint = endpoint;
			m_log.debug("set lastSuccessEndpoint. new one is " +
					lastSuccessEndpoint);
		}

		/**
		 * リストの順番を変えるメソッド。
		 * endpointListの順番で、lastSuccesEndpointをローテートする。
		 * @param endpoint
		 */
		private void changeEndpoint() {
			m_log.debug("changeEndpoint");
			boolean flag = false;
			for (HashMap<String, EndpointSetting> e : endpointList) {
				if (flag) {
					lastSuccessEndpoint = e;
					flag = false;
					return;
				}
				if (lastSuccessEndpoint.equals(e)) {
					flag = true;
				}
			}
			lastSuccessEndpoint = endpointList.get(0);
		}

		/**
		 * ログアウト
		 */
		private void logout() {
			for (HashMap<String, EndpointSetting> map : endpointList) {
				for (String key : map.keySet()) {
					EndpointSetting setting = map.get(key);
					setting.logout();
				}
			}
		}

		private int size() {
			return endpointList.size();
		}
	}

	public static class EndpointSetting {
		private String key;
		private String urlPrefix;
		private Object endpoint;
		private String wsdlSuffix = "?wsdl";

		private EndpointSetting(String key, String urlPrefix) {
			this.key = key;
			this.urlPrefix = urlPrefix;
		}

		private void logout() {
			endpoint = null;
		}

		public Object getEndpoint() {
			// ログインしていない場合は、ここでログインする。
			LoginManager.login();

			if (endpoint != null) {
				// set latest timeout
				setBindingProvider(endpoint, username, password, urlPrefix + key + wsdlSuffix);
				return endpoint;
			}
			String tmpKey = null;
			tmpKey = ACCESS;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				AccessEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new AccessEndpointService(
							new URL(urlStr),
							new QName("http://access.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():AccessEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getAccessEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = CALENDAR;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				CalendarEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new CalendarEndpointService(
							new URL(urlStr),
							new QName("http://calendar.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():CalendarEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getCalendarEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = COLLECTIVE_RUN;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				CollectiveRunEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new CollectiveRunEndpointService(
							new URL(urlStr),
							new QName("http://collectiverun.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():CollectiveRunEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getCollectiveRunEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = COLLECTOR;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				CollectorEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new CollectorEndpointService(
							new URL(urlStr),
							new QName("http://collector.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():CollectorEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getCollectorEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = JOB;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				JobEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new JobEndpointService(
							new URL(urlStr),
							new QName("http://jobmanagement.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():JobEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getJobEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = JOBMAP;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				JobMapEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new JobMapEndpointService(
							new URL(urlStr),
							new QName("http://jobmanagement.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():JobMapEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getJobMapEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = MAIL_TEMPLATE;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				MailTemplateEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new MailTemplateEndpointService(
							new URL(urlStr),
							new QName("http://mailtemplate.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():MailTemplateEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getMailTemplateEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = MAINTENANCE;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				MaintenanceEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new MaintenanceEndpointService(
							new URL(urlStr),
							new QName("http://maintenance.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():MaintenanceEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getMaintenanceEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = MONITOR;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				MonitorEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new MonitorEndpointService(
							new URL(urlStr),
							new QName("http://monitor.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():MonitorEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getMonitorEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = MONITOR_SETTING;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				MonitorSettingEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new MonitorSettingEndpointService(
							new URL(urlStr),
							new QName("http://monitor.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():MonitorSettingEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getMonitorSettingEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = MONITOR_SNMPTRAP;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				MonitorSnmpTrapEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new MonitorSnmpTrapEndpointService(
							new URL(urlStr),
							new QName("http://monitor.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():MonitorSnmpTrapEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getMonitorSnmpTrapEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = NODEMAP;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				NodeMapEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new NodeMapEndpointService(
							new URL(urlStr),
							new QName("http://nodemap.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():NodeMapEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getNodeMapEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = NOTIFY;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				NotifyEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new NotifyEndpointService(
							new URL(urlStr),
							new QName("http://notify.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():NotifyEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getNotifyEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			tmpKey = REPOSITORY;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				RepositoryEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new RepositoryEndpointService(
							new URL(urlStr),
							new QName("http://repository.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():RepositoryEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getRepositoryEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}

			tmpKey = PERFORMANCE_COLLECT_MASTER;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				PerformanceCollectMasterEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new PerformanceCollectMasterEndpointService(
							new URL(urlStr),
							new QName("http://collectmaster.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					m_log.warn("getEndpoint():PerformanceCollectMasterEndpointService, " + e.getMessage(), e);
				}
				endpoint = tmpEndpointService.getPerformanceCollectMasterEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}

			return endpoint;
		}
	}

	public static void init(String user, String pass, String managerAddressList,
			int httpConnectTimeout, int httpRequestTimeout) throws MalformedURLException {
		username = user;
		password = pass;
		endpointList = new EndpointList();
		m_httpConnectTimeout = httpConnectTimeout;
		m_httpRequestTimeout = httpRequestTimeout;

		for (String managerAddress : managerAddressList.split(",")) {

			// TODO ユーザ/パスワードチェックを実装する必要あり。
			HashMap<String, EndpointSetting> map = new HashMap<String, EndpointSetting>();
			String wsdlPrefix = managerAddress.trim();

			map.put(ACCESS, new EndpointSetting(ACCESS, wsdlPrefix));
			map.put(CALENDAR, new EndpointSetting(CALENDAR, wsdlPrefix));
			map.put(COLLECTIVE_RUN, new EndpointSetting(COLLECTIVE_RUN, wsdlPrefix));
			map.put(COLLECTOR, new EndpointSetting(COLLECTOR, wsdlPrefix));
			map.put(JOB, new EndpointSetting(JOB, wsdlPrefix));
			map.put(JOBMAP, new EndpointSetting(JOBMAP, wsdlPrefix));
			map.put(MAIL_TEMPLATE, new EndpointSetting(MAIL_TEMPLATE, wsdlPrefix));
			map.put(MAINTENANCE, new EndpointSetting(MAINTENANCE, wsdlPrefix));
			map.put(MONITOR, new EndpointSetting(MONITOR, wsdlPrefix));
			map.put(MONITOR_SETTING, new EndpointSetting(MONITOR_SETTING, wsdlPrefix));
			map.put(MONITOR_SNMPTRAP, new EndpointSetting(MONITOR_SNMPTRAP, wsdlPrefix));
			map.put(NOTIFY, new EndpointSetting(NOTIFY, wsdlPrefix));
			map.put(NODEMAP, new EndpointSetting(NODEMAP, wsdlPrefix));
			map.put(REPOSITORY, new EndpointSetting(REPOSITORY, wsdlPrefix));
			map.put(PERFORMANCE_COLLECT_MASTER, new EndpointSetting(PERFORMANCE_COLLECT_MASTER, wsdlPrefix));

			endpointList.add(map);
		}
		m_log.info("manager instance = " + endpointList.size());
	}

	private static void setBindingProvider(Object o, String user, String password, String urlStr) {
		BindingProvider bp = (BindingProvider)o;
		bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlStr);
		bp.getRequestContext().put(BindingProvider.USERNAME_PROPERTY, user);
		bp.getRequestContext().put(BindingProvider.PASSWORD_PROPERTY, password);

		bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", m_httpConnectTimeout * 1000);
		bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", m_httpRequestTimeout * 1000);
		if (m_log.isTraceEnabled()) {
			m_log.trace("ws timeout updated : connectTimeout = " + m_httpConnectTimeout + ", requestTimeout = " + m_httpRequestTimeout + "");
		}

		((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
	}

	/**
	 *  使用可能な順番でAccessEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getAccessEndpoint() {
		return endpointList.getList(ACCESS);
	}

	/**
	 *  使用可能な順番でCalenderEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getCalendarEndpoint() {
		return endpointList.getList(CALENDAR);
	}

	/**
	 *  使用可能な順番でCollectiveRunEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getCollectiveRunEndpoint() {
		return endpointList.getList(COLLECTIVE_RUN);
	}

	/**
	 * 使用可能な順番でCollectorEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getCollectorEndpoint() {
		return endpointList.getList(COLLECTOR);

	}
	/**
	 *  使用可能な順番でJobEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getJobEndpoint() {
		return endpointList.getList(JOB);
	}

	/**
	 *  使用可能な順番でJobMapEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getJobMapEndpoint() {
		return endpointList.getList(JOBMAP);
	}

	/**
	 *  使用可能な順番でMailTemplateEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getMailTemplateEndpoint() {
		return endpointList.getList(MAIL_TEMPLATE);
	}

	/**
	 *  使用可能な順番でMaintenanceEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getMaintenanceEndpoint() {
		return endpointList.getList(MAINTENANCE);
	}

	/**
	 *  使用可能な順番でMonitorEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getMonitorEndpoint() {
		return endpointList.getList(MONITOR);
	}

	/**
	 *  使用可能な順番でMonitorSettingEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getMonitorSettingEndpoint() {
		return endpointList.getList(MONITOR_SETTING);
	}

	/**
	 *  使用可能な順番でMonitorSnmpTrapEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getMonitorSnmpTrapEndpoint() {
		return endpointList.getList(MONITOR_SNMPTRAP);
	}

	/**
	 *  使用可能な順番でNotifyEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getNotifyEndpoint() {
		return endpointList.getList(NOTIFY);
	}

	/**
	 *  使用可能な順番でNodeMapEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getNodeMapEndpoint() {
		return endpointList.getList(NODEMAP);
	}

	/**
	 *  使用可能な順番でRepositoryEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getRepositoryEndpoint() {
		return endpointList.getList(REPOSITORY);
	}

	/**
	 *  使用可能な順番でRepositoryEndpointを返す。
	 * @return
	 */
	public static ArrayList<EndpointSetting> getPerformanceCollectMasterEndpoint() {
		return endpointList.getList(PERFORMANCE_COLLECT_MASTER);
	}

	/**
	 *  Endpointの利用時にWebServiceExceptionが出たらこのメソッドを呼ぶこと。
	 */
	public static void changeEndpoint() {
		endpointList.changeEndpoint();
	}

	/**
	 * ログアウト
	 */
	public static void logout() {
		m_log.debug("logout");
		username = null;
		password = null;
		if (endpointList == null) {
			return;
		}
		endpointList.logout();
	}
}
