package com.clustercontrol.snmptrap.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_snmp_trap_mst database table.
 * 
 */
@Embeddable
public class SnmpTrapMstEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String mib;
	private String trapOid;
	private Integer genericId;
	private Integer specificId;

	public SnmpTrapMstEntityPK() {
	}

	public SnmpTrapMstEntityPK(String mib,
			String trapOid,
			Integer genericId,
			Integer specificId) {
		this.setMib(mib);
		this.setTrapOid(trapOid);
		this.setGenericId(genericId);
		this.setSpecificId(specificId);
	}

	public String getMib() {
		return this.mib;
	}
	public void setMib(String mib) {
		this.mib = mib;
	}

	@Column(name="trap_oid")
	public String getTrapOid() {
		return this.trapOid;
	}
	public void setTrapOid(String trapOid) {
		this.trapOid = trapOid;
	}

	@Column(name="generic_id")
	public Integer getGenericId() {
		return this.genericId;
	}
	public void setGenericId(Integer genericId) {
		this.genericId = genericId;
	}

	@Column(name="specific_id")
	public Integer getSpecificId() {
		return this.specificId;
	}
	public void setSpecificId(Integer specificId) {
		this.specificId = specificId;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof SnmpTrapMstEntityPK)) {
			return false;
		}
		SnmpTrapMstEntityPK castOther = (SnmpTrapMstEntityPK)other;
		return
				this.mib.equals(castOther.mib)
				&& this.trapOid.equals(castOther.trapOid)
				&& this.genericId.equals(castOther.genericId)
				&& this.specificId.equals(castOther.specificId);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.mib.hashCode();
		hash = hash * prime + this.trapOid.hashCode();
		hash = hash * prime + this.genericId.hashCode();
		hash = hash * prime + this.specificId.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"mib",
				"trapOid",
				"genericId",
				"specificId"
		};
		String[] values = {
				this.mib,
				this.trapOid,
				this.genericId.toString(),
				this.specificId.toString()
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}