/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.monitor.util;

import java.sql.Timestamp;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.ObjectPrivilegeMode;
import com.clustercontrol.commons.util.HinemosEntityManager;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.EventLogNotFound;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.fault.ObjectPrivilege_InvalidRole;
import com.clustercontrol.monitor.bean.ConfirmConstant;
import com.clustercontrol.notify.monitor.model.EventLogEntity;
import com.clustercontrol.notify.monitor.model.EventLogEntityPK;
import com.clustercontrol.notify.monitor.model.StatusInfoEntity;
import com.clustercontrol.notify.monitor.model.StatusInfoEntityPK;

public class QueryUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( QueryUtil.class );

	public static StatusInfoEntity getStatusInfoPK(StatusInfoEntityPK pk) throws MonitorNotFound, InvalidRole {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		StatusInfoEntity entity = null;
		try {
			entity = em.find(StatusInfoEntity.class, pk);
			if (entity == null) {
				MonitorNotFound e = new MonitorNotFound("StatusInfoEntity.findByPrimaryKey"
						+ pk.toString());
				m_log.info("getStatusInfoPK() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage());
				throw e;
			}
		} catch (ObjectPrivilege_InvalidRole e) {
			m_log.info("getStatusInfoPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw new InvalidRole(e.getMessage(), e);
		}
		return entity;
	}

	public static StatusInfoEntity getStatusInfoPK(String facilityId,
			String monitorId,
			String monitorDetailId,
			String pluginId) throws MonitorNotFound, InvalidRole {
		return getStatusInfoPK(new StatusInfoEntityPK(facilityId, monitorId, monitorDetailId, pluginId));
	}

	public static List<StatusInfoEntity> getStatusInfoByExpirationStatus(Timestamp expirationDate) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<StatusInfoEntity> list
		= em.createNamedQuery("StatusInfoEntity.findExpirationStatus", StatusInfoEntity.class)
		.setParameter("expirationDate", expirationDate).getResultList();
		return list;
	}

	public static EventLogEntity getEventLogPK(EventLogEntityPK pk) throws EventLogNotFound, InvalidRole {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		EventLogEntity entity = null;
		try {
			entity = em.find(EventLogEntity.class, pk);
			if (entity == null) {
				EventLogNotFound e = new EventLogNotFound("EventLogEntity.findByPrimaryKey"
						+ pk.toString());
				m_log.info("getEventLogPK() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage());
				throw e;
			}
		} catch (ObjectPrivilege_InvalidRole e) {
			m_log.info("getEventLogPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw new InvalidRole(e.getMessage(), e);
		}
		return entity;
	}

	public static EventLogEntity getEventLogPK(String monitorId,
			String monitorDetailId,
			String pluginId,
			java.util.Date outputDate,
			String facilityId) throws EventLogNotFound, InvalidRole {
		return getEventLogPK(new EventLogEntityPK(monitorId, monitorDetailId, pluginId, outputDate, facilityId));
	}

	public static int updateEventLogFlgByFilter(String[] facilityIds,
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			String comment,
			String commentUser,
			Integer confirmFlg,
			Integer confirmType,
			String confirmUser) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		// 引数と反対の確認状態を取得する
		Integer selectConfirmFlg = null;
		if(confirmType == ConfirmConstant.TYPE_CONFIRMED){
			selectConfirmFlg = new Integer(ConfirmConstant.TYPE_UNCONFIRMED);
		}
		else if(confirmType == ConfirmConstant.TYPE_UNCONFIRMED){
			selectConfirmFlg = new Integer(ConfirmConstant.TYPE_CONFIRMED);
		}

		// SQL作成
		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("UPDATE EventLogEntity a SET a.confirmFlg = :confirmFlg, a.confirmDate = :confirmDate, a.confirmUser = :confirmUser");
		sbJpql.append(" WHERE true = true");

		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			sbJpql.append(" AND a.id.facilityId IN (" + HinemosEntityManager.getParamNameString("facilityId", facilityIds) + ")");
		}
		// 重要度設定
		if(priority != null) {
			sbJpql.append(" AND a.priority = :priority");
		}
		// 受信日時（自）設定
		if(outputFromDate != null) {
			sbJpql.append(" AND a.id.outputDate >= :outputFromDate");
		}
		// 受信日時（至）設定
		if(outputToDate != null) {
			sbJpql.append(" AND a.id.outputDate <= :outputToDate ");
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			sbJpql.append(" AND a.generationDate >= :generationFromDate ");
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			sbJpql.append(" AND a.generationDate <= :generationToDate ");
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			sbJpql.append(" AND a.application like :application ");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			sbJpql.append(" AND a.message like :message ");
		}
		// コメント
		if(comment != null && !"".equals(comment)){
			sbJpql.append(" AND a.comment like :comment ");
		}
		//コメントユーザ
		if(commentUser != null){
			sbJpql.append(" AND a.commentUser = :commentUser ");
		}
		// 確認有無
		if(selectConfirmFlg != null) {
			sbJpql.append(" AND a.confirmFlg = :selectConfirmFlg ");
		}

		TypedQuery<Integer> query = ((HinemosEntityManager)em).createQuery(sbJpql.toString(), Integer.class, EventLogEntity.class, ObjectPrivilegeMode.WRITE)
				.setParameter("confirmFlg", confirmFlg)
				.setParameter("confirmDate", new Timestamp(System.currentTimeMillis()))
				.setParameter("confirmUser", confirmUser);
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			query = HinemosEntityManager.appendParam(query, "facilityId", facilityIds);
		}
		// 重要度設定
		if(priority != null) {
			query.setParameter("priority", priority);
		}
		// 受信日時（自）設定
		if(outputFromDate != null) {
			query.setParameter("outputFromDate", outputFromDate);
		}
		// 受信日時（至）設定
		if(outputToDate != null) {
			query.setParameter("outputToDate", outputToDate);
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			query.setParameter("generationFromDate", generationFromDate);
		}
		// 出力日時（至）設定
		if(generationFromDate != null) {
			query.setParameter("generationToDate", generationToDate);
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			query.setParameter("application", "%" + application + "%");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			query.setParameter("message", "%" + message + "%");
		}
		// コメント
		if(comment != null && !"".equals(comment)){
			query.setParameter("comment", "%" + comment + "%");
		}
		//コメントユーザ
		if(commentUser != null){
			query.setParameter("commentUser", commentUser);
		}
		// 確認有無
		if(selectConfirmFlg != null) {
			query.setParameter("selectConfirmFlg", selectConfirmFlg);
		}

		return query.executeUpdate();
	}

	public static List<EventLogEntity> getEventLogByFilter(String[] facilityIds,
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			String confirmUser,
			String comment,
			String commentUser,
			String ownerRoleId,
			Boolean orderByFlg,
			Integer limit) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("SELECT a FROM EventLogEntity a WHERE true = true");
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			sbJpql.append(" AND a.id.facilityId IN (" + HinemosEntityManager.getParamNameString("facilityId", facilityIds) + ")");
		}
		// 重要度設定
		if (priority != null){
			sbJpql.append(" AND a.priority = :priority");
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			sbJpql.append(" AND a.id.outputDate >= :outputFromDate");
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			sbJpql.append(" AND a.id.outputDate <= :outputToDate");
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			sbJpql.append(" AND a.generationDate >= :generationFromDate");
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			sbJpql.append(" AND a.generationDate <= :generationToDate");
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			sbJpql.append(" AND a.application like :application");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			sbJpql.append(" AND a.message like :message");
		}
		// 確認有無
		if(confirmFlg != null) {
			sbJpql.append(" AND a.confirmFlg = :confirmFlg");
		}
		// 確認ユーザ
		if(confirmUser != null) {
			sbJpql.append(" AND a.confirmUser = :confirmUser");
		}
		//コメント
		if(comment != null && !"".equals(comment)){
			sbJpql.append(" AND a.comment like :comment");
		}
		//コメントユーザ
		if(commentUser != null){
			sbJpql.append(" AND a.commentUser = :commentUser");
		}
		//オーナーロールID
		if(ownerRoleId != null){
			sbJpql.append(" AND a.ownerRoleId = :ownerRoleId");
		}
		// ソート
		if (orderByFlg) {
			sbJpql.append(" ORDER BY a.id.outputDate");
		} else {
			sbJpql.append(" ORDER BY a.id.outputDate DESC");
		}
		TypedQuery<EventLogEntity> typedQuery
		= em.createQuery(sbJpql.toString(), EventLogEntity.class);
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			typedQuery = HinemosEntityManager.appendParam(typedQuery, "facilityId", facilityIds);
		}
		// 重要度設定
		if (priority != null){
			typedQuery = typedQuery.setParameter("priority", priority);
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			typedQuery = typedQuery.setParameter("outputFromDate", outputFromDate);
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			typedQuery = typedQuery.setParameter("outputToDate", outputToDate);
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			typedQuery = typedQuery.setParameter("generationFromDate", generationFromDate);
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			typedQuery = typedQuery.setParameter("generationToDate", generationToDate);
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			typedQuery = typedQuery.setParameter("application", "%" + application + "%");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			typedQuery = typedQuery.setParameter("message", "%" + message + "%");
		}
		// 確認有無
		if(confirmFlg != null) {
			typedQuery = typedQuery.setParameter("confirmFlg", confirmFlg);
		}
		// 確認ユーザ
		if(confirmUser != null) {
			typedQuery = typedQuery.setParameter("confirmUser", confirmUser);
		}
		//コメント
		if(comment != null && !"".equals(comment)){
			typedQuery = typedQuery.setParameter("comment", "%" + comment + "%");
		}
		//コメントユーザ
		if(commentUser != null){
			typedQuery = typedQuery.setParameter("commentUser", commentUser);
		}
		//オーナーロールID
		if(ownerRoleId != null){
			typedQuery = typedQuery.setParameter("ownerRoleId", ownerRoleId);
		}
		if (limit != null) {
			typedQuery = typedQuery.setMaxResults(limit);
		}

		return typedQuery.getResultList();
	}


	public static List<EventLogEntity> getEventLogByHighPriorityFilter(
			String[] facilityIds,
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			String confirmUser,
			Boolean orderByFlg) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("SELECT a FROM EventLogEntity a WHERE true = true");
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			sbJpql.append(" AND a.id.facilityId IN (" + HinemosEntityManager.getParamNameString("facilityId", facilityIds) + ")");
		}
		// 重要度設定
		if (priority != null){
			sbJpql.append(" AND a.priority = :priority");
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			sbJpql.append(" AND a.id.outputDate >= :outputFromDate");
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			sbJpql.append(" AND a.id.outputDate <= :outputToDate");
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			sbJpql.append(" AND a.generationDate >= :generationFromDate");
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			sbJpql.append(" AND a.generationDate <= :generationToDate");
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			sbJpql.append(" AND a.application like :application");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			sbJpql.append(" AND a.message like :message");
		}
		// 確認有無
		if(confirmFlg != null) {
			sbJpql.append(" AND a.confirmFlg = :confirmFlg");
		}
		// 確認ユーザ
		if(confirmUser != null) {
			sbJpql.append(" AND a.confirmUser = :confirmUser");
		}
		// ソート
		if (orderByFlg) {
			sbJpql.append(" ORDER BY a.id.outputDate DESC");
		}
		TypedQuery<EventLogEntity> typedQuery
		= em.createQuery(sbJpql.toString(), EventLogEntity.class);
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			typedQuery = HinemosEntityManager.appendParam(typedQuery, "facilityId", facilityIds);
		}
		// 重要度設定
		if (priority != null){
			typedQuery = typedQuery.setParameter("priority", priority);
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			typedQuery = typedQuery.setParameter("outputFromDate", outputFromDate);
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			typedQuery = typedQuery.setParameter("outputToDate", outputToDate);
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			typedQuery = typedQuery.setParameter("generationFromDate", generationFromDate);
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			typedQuery = typedQuery.setParameter("generationToDate", generationToDate);
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			typedQuery = typedQuery.setParameter("application", "%" + application + "%");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			typedQuery = typedQuery.setParameter("message", "%" + message + "%");
		}
		// 確認有無
		if(confirmFlg != null) {
			typedQuery = typedQuery.setParameter("confirmFlg", confirmFlg);
		}
		// 確認ユーザ
		if(confirmUser != null) {
			typedQuery = typedQuery.setParameter("confirmUser", confirmUser);
		}
		typedQuery = typedQuery.setMaxResults(1);

		return typedQuery.getResultList();
	}

	public static List<StatusInfoEntity> getStatusInfoByFilter(
			String[] facilityIds,
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			String ownerRoleId) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("SELECT a FROM StatusInfoEntity a WHERE true = true");
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			sbJpql.append(" AND a.id.facilityId IN (" + HinemosEntityManager.getParamNameString("facilityId", facilityIds) + ")");
		}
		// 重要度設定
		if (priority != null){
			sbJpql.append(" AND a.priority = :priority");
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			sbJpql.append(" AND a.outputDate >= :outputFromDate");
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			sbJpql.append(" AND a.outputDate <= :outputToDate");
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			sbJpql.append(" AND a.generationDate >= :generationFromDate");
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			sbJpql.append(" AND a.generationDate <= :generationToDate");
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			sbJpql.append(" AND a.application like :application");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			sbJpql.append(" AND a.message like :message");
		}
		// オーナーロールID設定
		if(ownerRoleId != null && !"".equals(ownerRoleId)) {
			sbJpql.append(" AND a.ownerRoleId = :ownerRoleId");
		}

		TypedQuery<StatusInfoEntity> typedQuery
		= em.createQuery(sbJpql.toString(), StatusInfoEntity.class);
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			typedQuery = HinemosEntityManager.appendParam(typedQuery, "facilityId", facilityIds);
		}
		// 重要度設定
		if (priority != null){
			typedQuery = typedQuery.setParameter("priority", priority);
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			typedQuery = typedQuery.setParameter("outputFromDate", outputFromDate);
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			typedQuery = typedQuery.setParameter("outputToDate", outputToDate);
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			typedQuery = typedQuery.setParameter("generationFromDate", generationFromDate);
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			typedQuery = typedQuery.setParameter("generationToDate", generationToDate);
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			typedQuery = typedQuery.setParameter("application", "%" + application + "%");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			typedQuery = typedQuery.setParameter("message", "%" + message + "%");
		}
		// オーナーロールID設定
		if(ownerRoleId != null && !"".equals(ownerRoleId)) {
			typedQuery = typedQuery.setParameter("ownerRoleId", ownerRoleId);
		}

		return typedQuery.getResultList();
	}

	public static List<StatusInfoEntity> getStatusInfoByHighPriorityFilter(
			String[] facilityIds,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			String ownerRoleId,
			boolean orderFlg) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("SELECT a FROM StatusInfoEntity a WHERE true = true");
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			sbJpql.append(" AND a.id.facilityId IN (" + HinemosEntityManager.getParamNameString("facilityId", facilityIds) + ")");
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			sbJpql.append(" AND a.outputDate >= :outputFromDate");
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			sbJpql.append(" AND a.outputDate <= :outputToDate");
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			sbJpql.append(" AND a.generationDate >= :generationFromDate");
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			sbJpql.append(" AND a.generationDate <= :generationToDate");
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			sbJpql.append(" AND a.application like :application");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			sbJpql.append(" AND a.message like :message");
		}
		// オーナーロールID設定
		if(ownerRoleId != null && !"".equals(ownerRoleId)) {
			sbJpql.append(" AND a.ownerRoleId = :ownerRoleId");
		}
		if (orderFlg) {
			sbJpql.append(" ORDER BY a.priority, a.outputDate DESC");
		} else {
			sbJpql.append(" ORDER BY a.priority");
		}
		TypedQuery<StatusInfoEntity> typedQuery
		= em.createQuery(sbJpql.toString(), StatusInfoEntity.class);
		// ファシリティID設定
		if(facilityIds != null && facilityIds.length>0) {
			typedQuery = HinemosEntityManager.appendParam(typedQuery, "facilityId", facilityIds);
		}
		// 受信日時（自）設定
		if (outputFromDate != null) {
			typedQuery = typedQuery.setParameter("outputFromDate", outputFromDate);
		}
		// 受信日時（至）設定
		if (outputToDate != null){
			typedQuery = typedQuery.setParameter("outputToDate", outputToDate);
		}
		// 出力日時（自）設定
		if(generationFromDate != null) {
			typedQuery = typedQuery.setParameter("generationFromDate", generationFromDate);
		}
		// 出力日時（至）設定
		if(generationToDate != null) {
			typedQuery = typedQuery.setParameter("generationToDate", generationToDate);
		}
		// アプリケーション設定
		if(application != null && !"".equals(application)) {
			typedQuery = typedQuery.setParameter("application", "%" + application + "%");
		}
		// メッセージ設定
		if(message != null && !"".equals(message)) {
			typedQuery = typedQuery.setParameter("message", "%" + message + "%");
		}
		// オーナーロールID設定
		if(ownerRoleId != null && !"".equals(ownerRoleId)) {
			typedQuery = typedQuery.setParameter("ownerRoleId", ownerRoleId);
		}
		typedQuery = typedQuery.setMaxResults(1);
		return typedQuery.getResultList();
	}
}
