/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security;

import java.util.Map;
import net.sf.jpasecurity.entity.SecureObjectCache;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluator;
import net.sf.jpasecurity.jpql.compiler.QueryPreparator;
import net.sf.jpasecurity.jpql.parser.JpqlAnd;
import net.sf.jpasecurity.jpql.parser.JpqlBooleanLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlBrackets;
import net.sf.jpasecurity.jpql.parser.JpqlOr;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.MappingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryOptimizer {
    private final QueryEvaluator evaluator;
    private final QueryEvaluationParameters parameters;
    private final NodeOptimizer nodeOptimizer = new NodeOptimizer();
    private final QueryPreparator queryPreparator = new QueryPreparator();

    public QueryOptimizer(MappingInformation mappingInformation, Map<Alias, Object> aliases, Map<String, Object> namedParameters, Map<Integer, Object> positionalParameters, QueryEvaluator evaluator, SecureObjectCache objectCache) {
        this.evaluator = evaluator;
        this.parameters = new QueryEvaluationParameters(mappingInformation, aliases, namedParameters, positionalParameters, true);
    }

    public void optimize(JpqlCompiledStatement compiledStatement) {
        this.optimize(compiledStatement.getWhereClause());
    }

    public void optimize(Node node) {
        node.visit(this.nodeOptimizer, new QueryEvaluationParameters(this.parameters));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeOptimizer
    extends JpqlVisitorAdapter<QueryEvaluationParameters> {
        private NodeOptimizer() {
        }

        @Override
        public boolean visit(JpqlWhere where, QueryEvaluationParameters data) {
            assert (where.jjtGetNumChildren() == 1);
            try {
                if (((Boolean)QueryOptimizer.this.evaluator.evaluate(where.jjtGetChild(0), data)).booleanValue()) {
                    QueryOptimizer.this.queryPreparator.remove(where);
                } else {
                    JpqlBooleanLiteral node = QueryOptimizer.this.queryPreparator.createBoolean(false);
                    QueryOptimizer.this.queryPreparator.replace(where.jjtGetChild(0), node);
                }
                return true;
            }
            catch (NotEvaluatableException e) {
                return true;
            }
        }

        @Override
        public boolean visit(JpqlOr node, QueryEvaluationParameters data) {
            assert (node.jjtGetNumChildren() == 2);
            try {
                if (((Boolean)QueryOptimizer.this.evaluator.evaluate(node.jjtGetChild(0), data)).booleanValue()) {
                    QueryOptimizer.this.queryPreparator.replace(node, QueryOptimizer.this.queryPreparator.createEquals(QueryOptimizer.this.queryPreparator.createBoolean(true), QueryOptimizer.this.queryPreparator.createBoolean(true)));
                } else {
                    QueryOptimizer.this.queryPreparator.replace(node, node.jjtGetChild(1));
                }
                return true;
            }
            catch (NotEvaluatableException e) {
                try {
                    if (((Boolean)QueryOptimizer.this.evaluator.evaluate(node.jjtGetChild(1), data)).booleanValue()) {
                        QueryOptimizer.this.queryPreparator.replace(node, QueryOptimizer.this.queryPreparator.createEquals(QueryOptimizer.this.queryPreparator.createBoolean(true), QueryOptimizer.this.queryPreparator.createBoolean(true)));
                    } else {
                        QueryOptimizer.this.queryPreparator.replace(node, node.jjtGetChild(0));
                    }
                    return true;
                }
                catch (NotEvaluatableException n) {
                    return true;
                }
            }
        }

        @Override
        public boolean visit(JpqlAnd node, QueryEvaluationParameters data) {
            assert (node.jjtGetNumChildren() == 2);
            try {
                if (((Boolean)QueryOptimizer.this.evaluator.evaluate(node.jjtGetChild(0), data)).booleanValue()) {
                    QueryOptimizer.this.queryPreparator.replace(node, node.jjtGetChild(1));
                } else {
                    QueryOptimizer.this.queryPreparator.replace(node, QueryOptimizer.this.queryPreparator.createBoolean(false));
                }
                return true;
            }
            catch (NotEvaluatableException e) {
                try {
                    if (((Boolean)QueryOptimizer.this.evaluator.evaluate(node.jjtGetChild(1), data)).booleanValue()) {
                        QueryOptimizer.this.queryPreparator.replace(node, node.jjtGetChild(0));
                    } else {
                        QueryOptimizer.this.queryPreparator.replace(node, QueryOptimizer.this.queryPreparator.createBoolean(false));
                    }
                    return true;
                }
                catch (NotEvaluatableException n) {
                    return true;
                }
            }
        }

        @Override
        public boolean visit(JpqlBrackets brackets, QueryEvaluationParameters data) {
            assert (brackets.jjtGetNumChildren() == 1);
            while (brackets.jjtGetChild(0) instanceof JpqlBrackets) {
                QueryOptimizer.this.queryPreparator.replace(brackets.jjtGetChild(0), brackets.jjtGetChild(0).jjtGetChild(0));
            }
            return true;
        }
    }
}

