/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.SecureCollection;
import net.sf.jpasecurity.entity.AbstractSecureCollection;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;
import net.sf.jpasecurity.entity.CollectionOperation;
import net.sf.jpasecurity.entity.DefaultSecureCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureList<E>
extends AbstractList<E>
implements SecureCollection<E> {
    private AbstractSecureCollection<E, List<E>> secureList;

    public SecureList(List<E> list, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        this.secureList = new DefaultSecureCollection(list, objectManager, accessManager);
    }

    SecureList(List<E> original, List<E> filtered, AbstractSecureObjectManager objectManager) {
        this.secureList = new DefaultSecureCollection(original, filtered, objectManager);
    }

    @Override
    public E get(int index) {
        return this.secureList.getFiltered().get(index);
    }

    @Override
    public E set(int index, final E element) {
        E old = this.secureList.getFiltered().set(index, element);
        final int originalIndex = this.getOriginal().indexOf(old);
        this.secureList.addOperation(new CollectionOperation<E, List<E>>(){

            @Override
            public void flush(List<E> original, AbstractSecureObjectManager objectManager) {
                original.set(originalIndex, objectManager.getUnsecureObject(element));
            }
        });
        return old;
    }

    @Override
    public void add(int index, final E element) {
        if (index == this.secureList.getFiltered().size()) {
            this.secureList.add(element);
        } else {
            E old = this.secureList.getFiltered().get(index);
            final int originalIndex = this.getOriginal().indexOf(old);
            this.secureList.addOperation(new CollectionOperation<E, List<E>>(){

                @Override
                public void flush(List<E> original, AbstractSecureObjectManager objectManager) {
                    original.add(originalIndex, objectManager.getUnsecureObject(element));
                }
            });
            this.secureList.getFiltered().add(index, element);
        }
    }

    @Override
    public E remove(int index) {
        E old = this.secureList.getFiltered().remove(index);
        this.secureList.remove(old);
        return old;
    }

    @Override
    public boolean addAll(int index, final Collection<? extends E> collection) {
        if (index == this.secureList.getFiltered().size()) {
            return this.secureList.addAll(collection);
        }
        E old = this.secureList.getFiltered().get(index);
        final int originalIndex = this.getOriginal().indexOf(old);
        this.secureList.addOperation(new CollectionOperation<E, List<E>>(){

            @Override
            public void flush(List<E> original, AbstractSecureObjectManager objectManager) {
                if (collection instanceof AbstractSecureCollection) {
                    AbstractSecureCollection secureCollection = (AbstractSecureCollection)collection;
                    original.addAll(originalIndex, secureCollection.getOriginal());
                } else if (collection instanceof SecureList) {
                    original.addAll(originalIndex, ((SecureList)collection).getOriginal());
                } else {
                    ArrayList list = new ArrayList();
                    for (Object entry : collection) {
                        list.add(objectManager.getUnsecureObject(entry));
                    }
                    original.addAll(originalIndex, list);
                }
            }
        });
        return this.secureList.getFiltered().addAll(index, collection);
    }

    @Override
    public int size() {
        return this.secureList.size();
    }

    @Override
    public boolean isInitialized() {
        return this.secureList.isInitialized();
    }

    @Override
    public boolean isDirty() {
        return this.secureList.isDirty();
    }

    public void flush() {
        this.secureList.flush();
    }

    @Override
    public SecureCollection<E> merge(SecureCollection<E> secureCollection) {
        if (!(secureCollection instanceof SecureList)) {
            throw new IllegalArgumentException("cannot merge collection of type " + secureCollection.getClass().getName());
        }
        SecureList secureList = (SecureList)secureCollection;
        this.secureList.merge(secureList.secureList);
        return secureList;
    }

    AbstractSecureObjectManager getObjectManager() {
        return this.secureList.getObjectManager();
    }

    List<E> getOriginal() {
        return this.secureList.getOriginal();
    }

    void initialize(boolean checkAccess) {
        this.secureList.initialize(checkAccess);
    }
}

