/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.proxy.MethodInterceptor;
import net.sf.jpasecurity.proxy.SecureEntityMethods;
import net.sf.jpasecurity.proxy.SuperMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureEntityInterceptor
implements MethodInterceptor {
    private boolean touched = false;
    private BeanInitializer beanInitializer;
    private AbstractSecureObjectManager objectManager;
    Object entity;

    public SecureEntityInterceptor(BeanInitializer beanInitializer, AbstractSecureObjectManager objectManager, Object entity) {
        this.beanInitializer = beanInitializer;
        this.objectManager = objectManager;
        this.entity = entity;
    }

    @Override
    public Object intercept(Object object, Method method, SuperMethod superMethod, Object ... args) throws Throwable {
        if (this.isHashCode(method)) {
            this.entity = this.beanInitializer.initialize(this.entity);
            return this.entity.hashCode();
        }
        if (this.isEquals(method)) {
            Object value = args[0];
            if (this.objectManager.isSecureObject(value)) {
                value = this.objectManager.getUnsecureObject(value);
            }
            this.entity = this.beanInitializer.initialize(this.entity);
            return this.entity.equals(value);
        }
        if (this.isCompareTo(method) && this.entity instanceof Comparable) {
            Object value = args[0];
            if (this.objectManager.isSecureObject(value)) {
                value = this.objectManager.getUnsecureObject(value);
            }
            this.entity = this.beanInitializer.initialize(this.entity);
            return this.compare((Comparable)this.entity, value);
        }
        if (this.isToString(method)) {
            this.entity = this.beanInitializer.initialize(this.entity);
            return this.entity.toString();
        }
        if (this.isFlush(method) && !this.touched) {
            return null;
        }
        try {
            if (!SecureEntityMethods.contains(method)) {
                if (!((SecureEntity)object).isInitialized()) {
                    ((SecureEntity)object).refresh();
                    this.touched = false;
                } else {
                    this.touched = true;
                }
            }
            Object value = superMethod.invoke(object, args);
            return value;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (this.isFlush(method)) {
                this.touched = false;
            }
        }
    }

    private boolean isEquals(Method method) {
        return method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    private boolean isHashCode(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    private boolean isToString(Method method) {
        return method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    private boolean isCompareTo(Method method) {
        return method.getName().equals("compareTo") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Integer.TYPE);
    }

    private boolean isFlush(Method method) {
        return method.getName().equals("flush") && method.getParameterTypes().length == 0;
    }

    private <T> int compare(Comparable<T> comparable, Object object) {
        return comparable.compareTo(object);
    }
}

