/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.AccessRulesProvider;
import net.sf.jpasecurity.configuration.AuthenticationProvider;
import net.sf.jpasecurity.configuration.AuthenticationProviderSecurityContext;
import net.sf.jpasecurity.configuration.DefaultExceptionFactory;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.mapping.PropertyAccessStrategyFactory;
import net.sf.jpasecurity.mapping.SecureBeanInitializer;
import net.sf.jpasecurity.proxy.SecureEntityProxyFactory;
import net.sf.jpasecurity.util.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String SECURITY_CONTEXT_PROPERTY = "net.sf.jpasecurity.security.context";
    public static final String DEFAULT_SECURITY_CONTEXT_CLASS = "net.sf.jpasecurity.security.authentication.AutodetectingSecurityContext";
    public static final String AUTHENTICATION_PROVIDER_PROPERTY = "net.sf.jpasecurity.security.authentication.provider";
    public static final String ACCESS_RULES_PROVIDER_PROPERTY = "net.sf.jpasecurity.security.rules.provider";
    public static final String DEFAULT_ACCESS_RULES_PROVIDER_CLASS = "net.sf.jpasecurity.security.rules.DefaultAccessRulesProvider";
    public static final String SECURE_ENTITY_PROXY_FACTORY_PROPERTY = "net.sf.jpasecurity.proxy.factory";
    public static final String DEFAULT_SECURE_ENTITY_PROXY_FACTORY_CLASS = "net.sf.jpasecurity.proxy.CgLibSecureEntityProxyFactory";
    public static final String PROPERY_ACCESS_STRATEGY_FACTORY_PROPERTY = "net.sf.jpasecurity.mapping.property.access.factory";
    public static final String DEFAULT_PROPERTY_ACCESS_STRATEGY_FACTORY_CLASS = "net.sf.jpasecurity.mapping.DefaultPropertyAccessStrategyFactory";
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private Map<String, Object> properties;
    private AccessRulesProvider accessRulesProvider;
    private SecurityContext securityContext;
    private SecureEntityProxyFactory secureEntityProxyFactory;
    private PropertyAccessStrategyFactory propertyAccessStrategyFactory;
    private BeanInitializer beanInitializer;
    private ExceptionFactory exceptionFactory;

    public Configuration() {
        this(null);
    }

    public Configuration(Map<String, Object> properties) {
        this.properties = properties != null ? new HashMap<String, Object>(properties) : Collections.emptyMap();
    }

    public Configuration(Configuration configuration, Map<String, Object> additionalProperties) {
        this.properties = new HashMap<String, Object>(configuration.properties);
        this.accessRulesProvider = configuration.getAccessRulesProvider();
        this.securityContext = configuration.getSecurityContext();
        this.secureEntityProxyFactory = configuration.getSecureEntityProxyFactory();
        this.propertyAccessStrategyFactory = configuration.getPropertyAccessStrategyFactory();
        this.beanInitializer = configuration.beanInitializer;
        this.exceptionFactory = configuration.getExceptionFactory();
        if (additionalProperties != null) {
            this.properties.putAll(additionalProperties);
        }
    }

    public AccessRulesProvider getAccessRulesProvider() {
        if (this.accessRulesProvider == null) {
            this.accessRulesProvider = this.createAccessRulesProvider();
        }
        return this.accessRulesProvider;
    }

    public void setAccessRulesProvider(AccessRulesProvider accessRulesProvider) {
        this.accessRulesProvider = accessRulesProvider;
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = this.createSecurityContext();
        }
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public SecureEntityProxyFactory getSecureEntityProxyFactory() {
        if (this.secureEntityProxyFactory == null) {
            this.secureEntityProxyFactory = this.createSecureEntityProxyFactory();
        }
        return this.secureEntityProxyFactory;
    }

    public void setSecureEntityProxyFactory(SecureEntityProxyFactory secureEntityProxyFactory) {
        this.secureEntityProxyFactory = secureEntityProxyFactory;
    }

    public PropertyAccessStrategyFactory getPropertyAccessStrategyFactory() {
        if (this.propertyAccessStrategyFactory == null) {
            this.propertyAccessStrategyFactory = this.createPropertyAccessStrategyFactory();
        }
        return this.propertyAccessStrategyFactory;
    }

    public void setPropertyAccessStrategyFactory(PropertyAccessStrategyFactory propertyAccessStrategyFactory) {
        this.propertyAccessStrategyFactory = propertyAccessStrategyFactory;
    }

    public ExceptionFactory getExceptionFactory() {
        if (this.exceptionFactory == null) {
            this.exceptionFactory = new DefaultExceptionFactory();
        }
        return this.exceptionFactory;
    }

    public void setExceptionFactory(ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    public BeanInitializer getBeanInitializer() {
        if (this.beanInitializer == null) {
            this.beanInitializer = new SecureBeanInitializer();
        }
        return this.beanInitializer;
    }

    public void setBeanInitializer(BeanInitializer initializer) {
        this.beanInitializer = initializer;
    }

    private AccessRulesProvider createAccessRulesProvider() {
        return this.newInstance(AccessRulesProvider.class, ACCESS_RULES_PROVIDER_PROPERTY, DEFAULT_ACCESS_RULES_PROVIDER_CLASS, new Object[0]);
    }

    private SecurityContext createSecurityContext() {
        AuthenticationProvider authenticationProvider;
        if (!this.properties.containsKey(SECURITY_CONTEXT_PROPERTY) && (authenticationProvider = this.createAuthenticationProvider()) != null) {
            return new AuthenticationProviderSecurityContext(authenticationProvider);
        }
        return this.newInstance(SecurityContext.class, SECURITY_CONTEXT_PROPERTY, DEFAULT_SECURITY_CONTEXT_CLASS, new Object[0]);
    }

    private AuthenticationProvider createAuthenticationProvider() {
        return this.newInstance(AuthenticationProvider.class, AUTHENTICATION_PROVIDER_PROPERTY, null, new Object[0]);
    }

    private SecureEntityProxyFactory createSecureEntityProxyFactory() {
        return this.newInstance(SecureEntityProxyFactory.class, SECURE_ENTITY_PROXY_FACTORY_PROPERTY, DEFAULT_SECURE_ENTITY_PROXY_FACTORY_CLASS, new Object[0]);
    }

    private PropertyAccessStrategyFactory createPropertyAccessStrategyFactory() {
        try {
            return this.newInstance(PropertyAccessStrategyFactory.class, PROPERY_ACCESS_STRATEGY_FACTORY_PROPERTY, DEFAULT_PROPERTY_ACCESS_STRATEGY_FACTORY_CLASS, this.getBeanInitializer());
        }
        catch (IllegalArgumentException e) {
            return this.newInstance(PropertyAccessStrategyFactory.class, PROPERY_ACCESS_STRATEGY_FACTORY_PROPERTY, DEFAULT_PROPERTY_ACCESS_STRATEGY_FACTORY_CLASS, new Object[0]);
        }
    }

    private <T> T newInstance(Class<T> type, String propertyName, String defaultPropertyValue, Object ... parameters) {
        Class<?> instanceClass;
        Object className = this.properties.get(propertyName);
        if (className == null) {
            className = defaultPropertyValue;
        }
        if (className == null) {
            LOG.info((Object)("No " + type.getSimpleName() + " configured"));
            return null;
        }
        LOG.info((Object)("Using " + className + " as " + type.getSimpleName()));
        try {
            instanceClass = this.getClass().getClassLoader().loadClass(className.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return (T)ReflectionUtils.newInstance(instanceClass, parameters);
    }
}

