/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import org.quartz.ScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.MutableTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScheduleBuilder
extends ScheduleBuilder<SimpleTrigger> {
    private long interval = 0L;
    private int repeatCount = 0;
    private int misfireInstruction = 0;

    protected SimpleScheduleBuilder() {
    }

    public static SimpleScheduleBuilder simpleSchedule() {
        return new SimpleScheduleBuilder();
    }

    public static SimpleScheduleBuilder repeatMinutelyForever() {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatMinutelyForever(int minutes) {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(minutes).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatSecondlyForever() {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatSecondlyForever(int seconds) {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(seconds).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatHourlyForever() {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatHourlyForever(int hours) {
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(hours).repeatForever();
        return sb;
    }

    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).withRepeatCount(count - 1);
        return sb;
    }

    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int count, int minutes) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(minutes).withRepeatCount(count - 1);
        return sb;
    }

    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(count - 1);
        return sb;
    }

    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int count, int seconds) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(seconds).withRepeatCount(count - 1);
        return sb;
    }

    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).withRepeatCount(count - 1);
        return sb;
    }

    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int count, int hours) {
        if (count < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + count);
        }
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(hours).withRepeatCount(count - 1);
        return sb;
    }

    @Override
    public MutableTrigger build() {
        SimpleTriggerImpl st = new SimpleTriggerImpl();
        st.setRepeatInterval(this.interval);
        st.setRepeatCount(this.repeatCount);
        st.setMisfireInstruction(this.misfireInstruction);
        return st;
    }

    public SimpleScheduleBuilder withIntervalInMilliseconds(long intervalInMillis) {
        this.interval = intervalInMillis;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInSeconds(int intervalInSeconds) {
        this.interval = (long)intervalInSeconds * 1000L;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInMinutes(int intervalInMinutes) {
        this.interval = (long)intervalInMinutes * 60000L;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInHours(int intervalInHours) {
        this.interval = (long)intervalInHours * 3600000L;
        return this;
    }

    public SimpleScheduleBuilder withRepeatCount(int triggerRepeatCount) {
        this.repeatCount = triggerRepeatCount;
        return this;
    }

    public SimpleScheduleBuilder repeatForever() {
        this.repeatCount = -1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionFireNow() {
        this.misfireInstruction = 1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithExistingCount() {
        this.misfireInstruction = 5;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithRemainingCount() {
        this.misfireInstruction = 4;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithExistingCount() {
        this.misfireInstruction = 2;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithRemainingCount() {
        this.misfireInstruction = 3;
        return this;
    }
}

