/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.systemlog.service.queue;

import java.net.InetAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeQueue {
	/** ログ出力のインスタンス  */
	private final static Log _log = LogFactory.getLog(NodeQueue.class);

	private final InetAddress _ipAddress;
	private final Queue<byte[]> _queue;

	volatile private long _inputCount = 0;
	volatile private long _outputCount = 0;
	volatile private long _dropCount = 0;
	volatile private long _maxDepth = 0;

	protected NodeQueue(InetAddress ipAddress){
		_ipAddress = ipAddress;
		_queue = new ConcurrentLinkedQueue<byte[]>();
	}

	protected boolean isEmpty() {
		return _queue.isEmpty();
	}

	protected void add(byte[] messageData){
		long depth = _inputCount - _outputCount;
		if(depth <= 1000){
			_queue.add(messageData);
			_inputCount++;

			if(depth > _maxDepth){
				_maxDepth = depth;
			}
		} else {
			_log.info("drop");
			_dropCount++;
		}
	}

	protected byte[] poll(){
		_outputCount++;
		return _queue.poll();
	}

	protected int size() {
		return _queue.size();
	}
}
