/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.priority.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.ejb.entity.PriorityInfoLocal;
import com.clustercontrol.priority.ejb.entity.PriorityInfoUtil;

/**
 * 重要度判定を検索するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectPriorityJudgment {

	/**
	 * 重要度判定情報を取得します。<BR>
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public PriorityJudgmentInfo getPriorityJudgment(String judgmentId) throws FinderException, NamingException {

		//重要度判定情報を検索し取得
		PriorityInfoLocal priority = PriorityInfoUtil.getLocalHome().findByPrimaryKey(judgmentId);

		PriorityJudgmentInfo info =
			new PriorityJudgmentInfo(
					priority.getJudgment_id(),
					priority.getDescription(),
					priority.getPattern_01(),
					priority.getPattern_02(),
					priority.getPattern_03(),
					priority.getPattern_04(),
					priority.getPattern_05(),
					priority.getPattern_06(),
					priority.getPattern_07(),
					priority.getPattern_08(),
					priority.getPattern_09(),
					priority.getPattern_10(),
					priority.getPattern_11(),
					priority.getPattern_12(),
					priority.getPattern_13(),
					priority.getPattern_14(),
					priority.getPattern_15(),
					priority.getReg_date(),
					priority.getUpdate_date(),
					priority.getReg_user(),
					priority.getUpdate_user());


		return info;
	}
}
