/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.factory;

import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.performance.monitor.bean.PerfCheckInfo;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * リソース監視判定情報検索クラス
 *
 * @version 4.0.0
 * @since 2.0.0
 */
public class SelectMonitorPerformance extends SelectMonitor{

	private static Log m_log = LogFactory.getLog( SelectMonitorPerformance.class );

	/**
	 * リソース監視情報を取得します。
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	protected PerfCheckInfo getPerfCheckInfo() throws FinderException, NamingException{
		m_log.debug("getPerfCheckInfo() monitorId = " + m_monitorId);

		// リソース監視情報を取得
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		PerfCheckInfo perfCheck = new PerfCheckInfo();
		perfCheck.setMonitorTypeId(m_monitorTypeId);
		perfCheck.setMonitorId(m_monitorId);
		perfCheck.setItemCode(perfLocal.getItemCode());
		perfCheck.setDeviceDisplayName(perfLocal.getDeviceDisplayName());
		perfCheck.setBreakdownFlg(perfLocal.getBreakdownFlg());

		return perfCheck;
	}


	/**
	 * リソース監視情報を取得
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param isGetAll 全監視情報取得フラグ
	 * @return MonitorInfo
	 * @throws CreateException
	 * @throws NamingException
	 * @throws HinemosUnknown
	 * @throws NotifyNotFound
	 * @throws MonitorNotFound
	 */
	@Override
	public MonitorInfo getMonitor(String monitorTypeId, String monitorId) throws CreateException, NamingException, NotifyNotFound, HinemosUnknown, MonitorNotFound {
		m_log.debug("getMonitor() monitorTypeId = " + monitorTypeId + ", monitorId = " + monitorId);

		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;

		MonitorInfo bean = null;
		try
		{
			// 監視情報を取得
			m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

			// スコープの取得
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			String facilityPath = repository.getFacilityPath(m_monitor.getFacilityId(), null);
			NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();


			//通知情報の取得
			Collection notifyId = nc.getNotifyRelation(m_monitor.getNotifyGroupId());

			bean = new MonitorInfo(
					m_monitor.getApplication(),
					m_monitor.getCalendarId(),
					m_monitor.getDescription(),
					facilityPath,
					m_monitor.getFacilityId(),
					m_monitor.getFailurePriority(),
					m_monitorId,
					m_monitorTypeId,
					m_monitor.getMonitorType(),
					m_monitor.getRegDate()==null?null:m_monitor.getRegDate().getTime(),
							m_monitor.getRegUser(),
							m_monitor.getRunInterval(),
							m_monitor.getNotifyGroupId(),
							notifyId,
							m_monitor.getUpdateDate()==null?null:m_monitor.getUpdateDate().getTime(),
									m_monitor.getUpdateUser(),
									m_monitor.getMonitorFlg(),
									m_monitor.getCollectorFlg(),
									m_monitor.getItemName(),
									m_monitor.getMeasure(),
									getNumericValueInfo(),
									getStringValueInfo(),
									getTruthValueInfo(),
									getTrapValueInfo(),
									getHttpCheckInfo(),
									getPerfCheckInfo(),
									getPingCheckInfo(),
									getPortCheckInfo(),
									getProcessCheckInfo(),
									getSnmpCheckInfo(),
									getSqlCheckInfo(),
									getTrapCheckInfo(),
									getCommandCheckInfo(),
									getLogfileCheckInfo(),
									getWinServiceCheckInfo());

		} catch (CreateException e) {
			outputLog(e, "getMonitor()", "010");
			m_log.warn("getMonitor()", e);
			throw e;
		} catch (FinderException e) {
			outputLog(e, "getMonitor()", "010");
			m_log.warn("getMonitor()", e);
			throw new MonitorNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			outputLog(e, "getMonitor()", "010");
			m_log.warn("getMonitor()", e);
			throw e;
		}

		return bean;
	}

	/**
	 * アプリケーションログにログを出力
	 * 
	 * @param e 例外
	 */
	private void outputLog(Exception e, String method, String index) {
		AplLogger apllog = new AplLogger("PERF", "perf");
		String[] args = {m_monitorTypeId, m_monitorId };
		apllog.put("SYS", index, args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
