package com.clustercontrol.monitor.run.util;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;

/**
 * 監視を並列実行するクラス<BR>
 * <p>
 *
 * @version 4.0.0
 * @since 2.4.0
 */
public class ParallelExecution {

	private static int m_maxThreadPool = 50;

	private static ExecutorService m_executorService = null;

	private Properties m_props;

	// ロガー
	private static Log log = LogFactory.getLog(ParallelExecution.class);

	// ロックオブジェクト
	private static Object lock = new Object();

	/**
	 * コンストラクタ
	 * @param props プロパティファイル情報
	 */
	public ParallelExecution(Properties props) {
		log.debug("ParallelExecution() props ");

		m_props = props;

		// プールするスレッドの最大数を取得
		String maxThreadPool = m_props.getProperty("monitor.common.thread.pool");
		if (maxThreadPool != null) {
			try {
				m_maxThreadPool = Integer.parseInt(maxThreadPool);
				log.debug("ParallelExecution() maxThreadPool = " + m_maxThreadPool);
			} catch (NumberFormatException e) {
				log.error("monitor.common.thread.pool",e);
			}
		}

		// ExecutorServiceの作成
		init();
	}

	/**
	 * 初期化
	 */
	private static void init(){
		log.debug("init()");

		m_executorService = Executors.newFixedThreadPool(m_maxThreadPool, Executors.privilegedThreadFactory());
		log.debug("ParallelExecution() ExecutorService is " + m_executorService.getClass().getCanonicalName());
		log.debug("ParallelExecution() securityManager is " + System.getSecurityManager());
	}

	/**
	 * タスクの実行
	 * 
	 * @param task
	 * @return
	 */
	public static Future<MonitorRunResultInfo>  submit(Callable<MonitorRunResultInfo> task){
		log.debug("submit()");

		synchronized (lock) {
			if(m_executorService == null){
				init();
			}
			return m_executorService.submit(task);

		}
	}

	/**
	 * タスクの実行(リソース監視)
	 * 
	 * @param task
	 * @return
	 */
	public static Future<ArrayList<MonitorRunResultInfo> >  submitPerf(Callable<ArrayList<MonitorRunResultInfo>> task){
		log.debug("submit() resource");

		synchronized (lock) {
			if(m_executorService == null){
				init();
			}
			return m_executorService.submit(task);

		}
	}
}
