/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * ジョブの管理ユーザに関する情報を保持するクラス
 * 
 * @version 3.2.0
 * @since 3.2.0
 *
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobManagementUserInfo implements Serializable, Cloneable {

	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = -6403067943831215402L;

	/** ユーザID */
	private String m_userId;

	/** ユーザ名 */
	private String m_userName;

	/** 説明 */
	private String m_description;


	/**
	 * 管理ユーザのユーザIDを返す。<BR>
	 * @return 管理ユーザのユーザID
	 */
	public String getUserId() {
		return m_userId;
	}

	/**
	 * 管理ユーザのユーザIDを設定する。<BR>
	 * @param userId 管理ユーザのユーザID
	 */
	public void setUserId(String userId) {
		m_userId = userId;
	}

	/**
	 * 管理ユーザのユーザ名を返す。<BR>
	 * @return 管理ユーザのユーザ名
	 */
	public String getUserName() {
		return m_userName;
	}

	/**
	 * 管理ユーザのユーザ名を設定する。<BR>
	 * @param userName 管理ユーザのユーザ名
	 */
	public void setUserName(String userName) {
		m_userName = userName;
	}

	/**
	 * 管理ユーザの説明を返す<BR>
	 * @return 管理ユーザの説明
	 */
	public String getDescription() {
		return m_description;
	}

	/**
	 * 管理ユーザの説明を設定する<BR>
	 * @param m_description 管理ユーザの説明
	 */
	public void setDescription(String m_description) {
		this.m_description = m_description;
	}


	/**
	 * 管理ユーザ情報のクローンを作成する。<BR>
	 * 
	 * @return 管理ユーザ情報のクローン
	 * 
	 */
	@Override
	protected Object clone() {

		JobManagementUserInfo clone;
		try {
			clone = (JobManagementUserInfo)super.clone();

			clone.setUserId(this.getUserId());
			clone.setUserName(this.getUserName());
			clone.setDescription(this.getDescription());

			return clone;

		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}
