/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.custom.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;

/**
 * コマンド監視の特有設定項目を保持するエンティティクラス
 * 
 * @ejb.bean
 *     name="MonitorCustomInfo"
 *     jndi-name="MonitorCustomInfo"
 *     schema="MonitorCustomInfo"
 *     view-type="local"
 *     type="CMP"
 *     cmp-version="2.x"
 *     primkey-field="monitorId"
 * 
 * @ejb.pk
 *     class="java.lang.String"
 * 
 * @ejb.persistence
 *     table-name="cc_monitor_custom_info"
 * 
 * @ejb.finder
 *     query="SELECT OBJECT(a) FROM MonitorCustomInfo AS a"
 *     signature="java.util.Collection findAll()"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @jboss.depends
 *     name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *     name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.perssitence
 *     datasource="java:/DefaultDS"
 *     datasource-mapping="PostgreSQL 8.0"
 *     create-table="false"
 *     remove-table="false"
 *     alter-table="false"
 * 
 * @jboss.read-ahead
 *     strategy="on-find"
 * 
 * @jboss.method-attributes
 *     pattern="get*"
 *     read-only="true"
 * 
 */
public abstract class MonitorCustomInfoBean implements EntityBean {

	/**
	 * インスタンスのメンバ変数を格納する
	 * @ejb.create-method
	 * 
	 * @param monitorId コマンド監視の監視ID
	 * @param type コマンド実行種別(個々に実行するのか、特定ノードで実行するのか)
	 * @param facilityId 特定ノードで実行する場合は、そのファシリティID
	 * @param effectiveUser コマンドの実効ユーザ
	 * @param command コマンド文字列()
	 * @return 必ずnullを返す
	 * @throws CreateException エンティティの生成に失敗した場合
	 */
	public String ejbCreate(String monitorId,
			com.clustercontrol.custom.CustomConstant.CommandExecType type,
			String facilityId, String effectiveUser, String command, Integer timeout) throws CreateException {

		setMonitorId(monitorId);
		setCommandExecType(type);
		if (type == com.clustercontrol.custom.CustomConstant.CommandExecType.SELECTED) {
			setSelectedFacilityId(facilityId);
		}
		setEffectiveUser(effectiveUser);
		setCommand(command);
		setTimeout(timeout);

		return null;
	}

	/**
	 * コマンド監視設定の監視項目IDを返す
	 * @return コマンド監視の監視ID
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 */
	public abstract String getMonitorId();

	/**
	 * コマンド監視設定の監視項目IDをセットする
	 * @param monitorId コマンド監視の監視ID
	 * 
	 * @ejb.interface-method
	 */
	public abstract void setMonitorId(String monitorId);

	/**
	 * コマンド監視設定の実行種別(DB値)を返す。ユーザはこのAPIではなく、getCommandExecTypeを利用すること。
	 * @return コマンド監視の種別ID(DB内部に保持される値)
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="execute_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 */
	public abstract int getType();

	/**
	 * コマンド監視設定の実行種別(DB値)をセットする。ユーザはこのAPIではなく、setCommandExecTypeを利用すること。
	 * @param type コマンド監視の種別ID(DB内部に保持される値)
	 */
	public abstract void setType(int type);

	/**
	 * コマンド監視設定において、コマンドの実行対象となっている特定ノードのファシリティIDを返す
	 * @return コマンドの実行対象となっている特定ノードのファシリティID
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="selected_facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 */
	public abstract String getSelectedFacilityId();

	/**
	 * コマンド監視設定において、コマンドの実行対象となっている特定ノードのファシリティIDを設定する
	 * @param facilityId コマンドの実行対象となっている特定ノードのファシリティID
	 * 
	 * @ejb.interface-method
	 */
	public abstract void setSelectedFacilityId(String facilityId);

	/**
	 * コマンド監視設定のコマンド実効ユーザを返す
	 * @return コマンドの実効ユーザ
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="effective_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 */
	public abstract String getEffectiveUser();

	/**
	 * コマンド監視設定のコマンド実効ユーザをセットする
	 * @param effectiveUser コマンドの実効ユーザ
	 * 
	 * @ejb.interface-method
	 */
	public abstract void setEffectiveUser(String effectiveUser);

	/**
	 * コマンド監視設定のコマンド文字列を返す
	 * @return コマンド文字列
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="command"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 */
	public abstract String getCommand();

	/**
	 * コマンド監視設定のコマンド文字列をセットする
	 * @param command コマンド文字列
	 * 
	 * @ejb.interface-method
	 */
	public abstract void setCommand(String command);

	/**
	 * コマンド監視設定のコマンド実行種別を返す
	 * @return コマンド実行種別
	 * 
	 * @ejb.interface-method
	 */
	public com.clustercontrol.custom.CustomConstant.CommandExecType getCommandExecType() {
		return getType() == com.clustercontrol.custom.CustomConstant._execIndividual ? com.clustercontrol.custom.CustomConstant.CommandExecType.INDIVIDUAL : com.clustercontrol.custom.CustomConstant.CommandExecType.SELECTED;
	}

	/**
	 * コマンド監視設定のコマンド実行種別をセットする
	 * @param type コマンド実行種別
	 * 
	 * @ejb.interface-method
	 */
	public void setCommandExecType(com.clustercontrol.custom.CustomConstant.CommandExecType type) {
		setType(type == com.clustercontrol.custom.CustomConstant.CommandExecType.INDIVIDUAL ? com.clustercontrol.custom.CustomConstant._execIndividual : com.clustercontrol.custom.CustomConstant._execSelected);
	}

	/**
	 * コマンド監視設定のタイムアウト時間を返す
	 * @return タイムアウト時間[msec]
	 * 
	 * @ejb.persistent-field
	 * 
	 * @ejb.persistence
	 *     column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 */
	public abstract Integer getTimeout();

	/**
	 * コマンド監視設定のコマンド文字列をセットする
	 * @param command コマンド文字列
	 * 
	 * @ejb.interface-method
	 */
	public abstract void setTimeout(Integer timeout);
}
