package com.clustercontrol.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.agent.EndpointManager.EndpointSetting;
import com.clustercontrol.agent.util.AgentProperties;
import com.clustercontrol.util.XMLUtil;
import com.clustercontrol.ws.agent.AgentEndpoint;
import com.clustercontrol.ws.agent.AgentOutputBasicInfo;
import com.clustercontrol.ws.agent.CustomInvalid_Exception;
import com.clustercontrol.ws.agent.FacilityNotFound_Exception;
import com.clustercontrol.ws.agent.HinemosUnknown_Exception;
import com.clustercontrol.ws.agent.InvalidRole_Exception;
import com.clustercontrol.ws.agent.InvalidUserPass_Exception;
import com.clustercontrol.ws.agent.JobInfoNotFound_Exception;
import com.clustercontrol.ws.agent.MessageInfo;
import com.clustercontrol.ws.agent.MonitorNotFound_Exception;
import com.clustercontrol.ws.agent.OutputBasicInfo;
import com.clustercontrol.ws.agent.SettingUpdateInfo;
import com.clustercontrol.ws.agent.TopicInfo;
import com.clustercontrol.ws.jobmanagement.RunResultInfo;
import com.clustercontrol.ws.monitor.CommandExecuteDTO;
import com.clustercontrol.ws.monitor.CommandResultDTO;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorStringValueInfo;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class AgentEndPointWrapper {

	//ロガー
	private static Log m_log = LogFactory.getLog(AgentEndPointWrapper.class);

	/** XML のInvalidな文字を置換する場合の置換文字のキー */
	private static final String MESSAGE_REPLACE_METHOD_KEY = "common.xml.invalid.char.replace";
	
	/** XML のInvalidな文字を置換する場合の置換文字のキー */
	private static final String MESSAGE_REPLACE_CHAR_KEY = "common.xml.invalid.char.replace.to";
	
	static {
		String replaceMethodString = AgentProperties.getProperty(MESSAGE_REPLACE_METHOD_KEY, "false");
		if("true".equals(replaceMethodString)){
			XMLUtil.setReplace(true);
		} else {
			XMLUtil.setReplace(false);
		}
		
		String replaceCharString = AgentProperties.getProperty(MESSAGE_REPLACE_CHAR_KEY, "?");
		if(replaceCharString != null){
			XMLUtil.setReplaceChar(replaceCharString);
		}
	}
	
	public static void jobResult(RunResultInfo resultInfo)
	throws HinemosUnknown_Exception, JobInfoNotFound_Exception,
	InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				
				// Ignore Invalid XML Chars
				resultInfo.setMessage(XMLUtil.ignoreInvalidString(resultInfo.getMessage()));
				resultInfo.setErrorMessage(XMLUtil.ignoreInvalidString(resultInfo.getErrorMessage()));
				
				endpoint.jobResult(resultInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("jobResult " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void sendMessage(AgentOutputBasicInfo info)
	throws FacilityNotFound_Exception, HinemosUnknown_Exception,
	InvalidRole_Exception, InvalidUserPass_Exception {
		info.setAgentInfo(Agent.getAgentInfo());
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				
				// Ignore Invalid XML Chars
				OutputBasicInfo outputInfo = info.getOutputBasicInfo();
				outputInfo.setMessage(XMLUtil.ignoreInvalidString(outputInfo.getMessage()));
				outputInfo.setMessageOrg(XMLUtil.ignoreInvalidString(outputInfo.getMessageOrg()));
				
				endpoint.sendMessage(info);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<TopicInfo> getTopic()
	throws InvalidRole_Exception, InvalidUserPass_Exception, HinemosUnknown_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				return endpoint.getTopic(Agent.getAgentInfo());
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static SettingUpdateInfo getSettingUpdateInfo()
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		// Local Variables
		WebServiceException wse = null;
		SettingUpdateInfo wsDTO;

		// MAIN
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				wsDTO = endpoint.getSettingUpdateInfo();
				return wsDTO;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("communication failure to manager...", e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ArrayList<CommandExecuteDTO> getCommandExecuteDTOs()
	throws HinemosUnknown_Exception, CustomInvalid_Exception,
	InvalidRole_Exception, InvalidUserPass_Exception {
		// Local Variables
		WebServiceException wse = null;
		ArrayList<CommandExecuteDTO> wsDTO = null;

		// MAIN
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				wsDTO = (ArrayList<CommandExecuteDTO>)endpoint.getCommandExecuteDTO(Agent.getAgentInfo());
				return wsDTO;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("communication failure to manager...", e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void putCommandResultDTO(CommandResultDTO result)
	throws HinemosUnknown, InvalidRole_Exception,
	InvalidUserPass_Exception, HinemosUnknown_Exception {
		// Local Variables
		WebServiceException wse = null;

		// MAIN
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				
				// Ignore Invalid XML Chars
				result.setStderr(XMLUtil.ignoreInvalidString(result.getStderr()));
				result.setStdout(XMLUtil.ignoreInvalidString(result.getStdout()));
				
				endpoint.putCommandResultDTO(result);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ArrayList<MonitorInfo> getMonitorLogfile()
	throws HinemosUnknown_Exception, InvalidRole_Exception,
	InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				return (ArrayList<MonitorInfo>) endpoint.getMonitorLogfile(Agent.getAgentInfo());
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteAgent()
	throws InvalidRole_Exception, InvalidUserPass_Exception,
	HinemosUnknown_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteAgent(Agent.getAgentInfo());
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static DataHandler downloadModule(String filename)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, IOException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				return endpoint.downloadModule(filename);
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static HashMap<String, String> getAgentLibMap()
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception  {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				List<String> list = endpoint.getAgentLibMap();
				Iterator<String> itr = list.iterator();
				HashMap<String, String> ret = new HashMap<String, String>();
				while (itr.hasNext()) {
					ret.put(itr.next(), itr.next());
				}
				return ret;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void setAgentLibMd5(HashMap<String, String> agentLibMd5)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;

		ArrayList<String> agentLibMd5List = new ArrayList<String> ();
		for (String str : agentLibMd5.keySet()) {
			agentLibMd5List.add(str);
			agentLibMd5List.add(agentLibMd5.get(str));
		}
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				endpoint.setAgentLibMd5(agentLibMd5List, Agent.getAgentInfo());
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void sendNotify(String message, MessageInfo logmsg,
			MonitorInfo monitorInfo, MonitorStringValueInfo rule)
	throws HinemosUnknown_Exception, InvalidRole_Exception,
	InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getAgentEndpoint()) {
			try {
				AgentEndpoint endpoint = (AgentEndpoint) endpointSetting.getEndpoint();
				
				// Ignore Invalid XML Chars
				message = XMLUtil.ignoreInvalidString(message);
				logmsg.setMessage(XMLUtil.ignoreInvalidString(logmsg.getMessage()));
				
				endpoint.sendNotify(message, logmsg, monitorInfo, rule, Agent.getAgentInfo());
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.info("WebServiceException " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
