/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGControllerLocal;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGControllerUtil;

/**
 * syslog-ng監視用のWebAPIエンドポイント
 */
@javax.jws.WebService
public class MonitorSyslogNGEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorSyslogNGEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorSyslogNGControllerLocal getMonitorSyslogNGControllerLocal() throws HinemosUnknownException {
		MonitorSyslogNGControllerLocal monitor = null;
		try {
			monitor = MonitorSyslogNGControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorSyslogNGControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorSyslogNGControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * フィルタ情報一覧を取得します。<BR>
	 * 
	 * ArrayListにはLogFilterInfoが格納されています。
	 * 
	 * @return フィルタ情報一覧 （{@link com.clustercontrol.syslogng.bean.LogFilterInfo}のリスト）
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * 
	 * @see com.clustercontrol.syslogng.factory.SelectMonitorRule#getFilterInfoList()
	 */
	public ArrayList<LogFilterInfo> getFilterInfoList() throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getFilterInfoList : ");
		MonitorSyslogNGControllerLocal monitor = getMonitorSyslogNGControllerLocal();
		return monitor.getFilterInfoList();
	}

	/**
	 * フィルタ情報をマネージャに登録します。<BR>
	 * 
	 * @param filterInfoList フィルタ情報一覧 （{@link com.clustercontrol.syslogng.bean.LogFilterInfo}のリスト）
	 * @return 登録に成功した場合、<code> true </code>
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * 
	 * @see com.clustercontrol.syslogng.factory.ModifyMonitorRule#deleteMonitorRule()
	 * @see com.clustercontrol.syslogng.factory.ModifyMonitorRule#createMonitorRule(ArrayList, String)
	 */
	public boolean createMonitorRuleList(ArrayList<LogFilterInfo> filterInfoList) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("createMonitorRuleList : filterInfoList=" + filterInfoList);
		MonitorSyslogNGControllerLocal monitor = getMonitorSyslogNGControllerLocal();
		return monitor.createMonitorRuleList(filterInfoList);
	}
	
	/**
	 * ファシリティIDが使用されているかチェックします。<BR>
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @param facilityId ファシリティ
	 * @throws HinemosUnknownException 
	 * @throws UsedFacilityException 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	/*
	public void isUseFacilityId(String facilityId) throws HinemosUnknownException, UsedFacilityException {
		MonitorSyslogNGControllerLocal monitor = getMonitorSyslogNGControllerLocal();
		monitor.isUseFacilityId(facilityId);
	}
	*/
}
