/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.bean.JdbcDriverInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlControllerLocal;
import com.clustercontrol.sql.ejb.session.MonitorSqlControllerUtil;

/**
 * SQL監視用のWebAPIエンドポイント
 */
@javax.jws.WebService
public class MonitorSqlEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorSqlEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorSqlControllerLocal getMonitorSqlControllerLocal() throws HinemosUnknownException {
		MonitorSqlControllerLocal monitor = null;
		try {
			monitor = MonitorSqlControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorSqlControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorSqlControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * SQL監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException
	 * @throws HinemosUnknownException 
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addSqlMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException{
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("addSqlMonitor : monitorId=" + id + ", monitorInfo=" + info);
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.addSql(info);
	}
	
	/**
	 * マネージャ上のSQL監視情報を更新します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifySqlMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException{
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("modifySqlMonitor : monitorId=" + id + ", monitorInfo=" + info);
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.modifySql(info);
	}
	
	/**
	 * SQL監視情報をマネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deleteSqlMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		m_log.debug("deleteSqlMonitor : monitorId=" + monitorId);
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.deleteSql(monitorId);
	}
	
	/**
	 * SQL監視情報を取得します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return SQL監視情報
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public MonitorInfo getSqlMonitor(String monitorId, int monitorType) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getSqlMonitor : monitorId=" + monitorId + ", monitorType=" + monitorType);
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.getSqlInfo(monitorId);
	}

	/**
	 * SQL監視一覧リストを取得します。
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorInfo> getSqlList() throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getSqlList : ");
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.getSqlList();
	}
	
	/**
	 * JDBC定義一覧をリストで返却します。<BR>
	 * 
	 * @return JDBC定義のリスト
	 * @throws HinemosUnknownException 
	 */
	public ArrayList<JdbcDriverInfo> getJdbcDriverList() throws HinemosUnknownException{
		m_log.debug("getJdbcDriverList : ");
		MonitorSqlControllerLocal monitor = getMonitorSqlControllerLocal();
		return monitor.getJdbcDriverList();
	}
}
