/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerLocal;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerUtil;

/**
 * SNMPTRAP監視用のWebAPIエンドポイント
 */
@javax.jws.WebService
public class MonitorSnmpTrapEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorSnmpTrapEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorSnmpTrapControllerLocal getMonitorSnmpTrapControllerLocal() throws HinemosUnknownException {
		MonitorSnmpTrapControllerLocal monitor = null;
		try {
			monitor = MonitorSnmpTrapControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorSnmpTrapControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorSnmpTrapControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * SNMPTRAP監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws MonitorDuplicateException
	 * @throws HinemosUnknownException 
	 */
	public boolean addSnmpTrapMonitor(MonitorSnmpTrapInfo info) throws MonitorNotFoundException, MonitorDuplicateException, HinemosUnknownException {
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("addSnmpTrapMonitor : monitorId=" + id + ", monitorSnmpTrapInfo=" + info);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.addMonitor(info);
	}
	
	/**
	 * マネージャのSNMP TRAP監視情報を更新します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean modifySnmpTrapMonitor(MonitorSnmpTrapInfo info) throws MonitorNotFoundException, HinemosUnknownException{
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("modifySnmpTrapMonitor : monitorId=" + id + ", monitorSnmpTrapInfo=" + info);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.modifyMonitor(info);
	}
	
	/**
	 * SQL監視情報をマネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean deleteSnmpTrapMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("deleteSnmpTrapMonitor : monitorId=" + monitorId);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.deleteMonitor(monitorId);
	}
	
	/**
	 * MIB一覧を取得します。<BR>
	 * 
	 * 戻り値はMIBの名前(String)のArrayListです。
	 * 
	 * @return MIB一覧
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public ArrayList<String> getMibList() throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getMibList : ");
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.getMibList();
	}
	
	/**
	 * 監視マスタ情報一覧を取得します。<BR>
	 * 
	 * 
	 * 戻り値はSnmpTrapMasterInfoのArrayListです。
	 * 
	 * @return MIB一覧
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo
	 */
	public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getMasterList : mib=" + mib);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.getMasterList(mib);
	}
	
	/**
	 * SNMPTRAP監視設定情報を取得します。
	 * 
	 * @param monitorId 監視項目ID
	 * @return 監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo
	 */
	public MonitorSnmpTrapInfo getSnmpTrapMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getSnmpTrapMonitor : monitorId=" + monitorId);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.getMonitorInfo(monitorId);
	}

	/**
	 * SNMPTRAP監視一覧リストを取得します。<BR>
	 * 
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorSnmpTrapInfo> getSnmpTrapList() throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getSnmpTrapList : ");
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.getMonitorList();
	}
	
	/**
	 * ファシリティIDが使用されているかチェックします。<BR>
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacilityException
	 * @throws HinemosUnknownException
	 * 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	/*
	public void isUseFacilityId(String facilityId) throws UsedFacilityException, HinemosUnknownException {
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		monitor.isUseFacilityId(facilityId);
	}
	*/
	
	
	/**
	 * MIBの内容を取得します。<BR>
	 * 
	 * 戻り値はMIBのDTO(SnmpTrapMibMasterData)です。
	 * 
	 * @return MIB一覧
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public SnmpTrapMibMasterData getMib(String Mib) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getMib : mib=" + Mib);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.getMib(Mib);
	}
	
	/**
	 * MIB情報の登録
	 *
	 * @param MibData
	 * @return
	 * @throws HinemosUnknownException 
	 */
	public boolean addMibMaster(SnmpTrapMibMasterData MibData) throws HinemosUnknownException {
		m_log.debug("addMibMaster : snmpTrapMibMasterData=" + MibData);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.addMibMaster(MibData);
	}
	
	/**
	 * MIB情報の変更
	 * 
	 * @param MibData
	 * @return
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean modifyMibMaster(SnmpTrapMibMasterData MibData) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("modifyMibMaster : snmpTrapMibMasterData=" + MibData);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.modifyMibMaster(MibData);
	}
	
	/**
	 * MIB情報の削除
	 * 
	 * @param mib
	 * @return
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean deleteMibMaster(String Mib) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("deleteMibMaster : mib=" + Mib);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.deleteMibMaster(Mib);
	}
	
	
	/**
	 * OID情報の登録
	 *
	 * @param MibData
	 * @return
	 * @throws HinemosUnknownException 
	 */
	public boolean addOidMaster(SnmpTrapMasterInfo Oid) throws HinemosUnknownException {
		m_log.debug("addOidMaster : snmpTrapMasterInfo="+ Oid);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.addOidMaster(Oid);
	}
	
	/**
	 * OID情報の変更
	 * 
	 * @param MibData
	 * @return
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean modifyOidMaster(SnmpTrapMasterInfo Oid) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("modifyOidMaster : snmpTrapMasterInfo="+ Oid);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.modifyOidMaster(Oid);
	}
	
	/**
	 * OID情報の削除
	 * 
	 * @param mib
	 * @return
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean deleteOidMaster(SnmpTrapMasterInfo oid) throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("deleteOidMaster : snmpTrapMasterInfo="+ oid);
		MonitorSnmpTrapControllerLocal monitor = getMonitorSnmpTrapControllerLocal();
		return monitor.deleteOidMaster(oid);
	}
}
