/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.repository.ejb.entity.NodeLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NodeHostname" 
 *    jndi-name="NodeHostname"
 *    type="CMP" 
 *    view-type="local"
 *    schema="NodeHostnameSCHEMA" 
 *    cmp-version="2.x"
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_node_hostname" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NodeHostnameSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.repository.ejb.entity.NodeHostnameBeanPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_node_hostname"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class NodeHostnameBean implements javax.ejb.EntityBean {

	/**
	 * Generated Primary Key Class
	 * @generated
	 */
	public class PrimaryKey {
		/**
		 * @generated
		 */
		public java.lang.String facilityId;
		/**
		 * @generated
		 */
		public java.lang.String hostname;
	}

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public NodeHostnameBeanPK ejbCreate(java.lang.String facilityId, java.lang.String hostname)
			throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setFacilityId(facilityId);
		setHostname(hostname);
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field hostname
	 *
	 * Returns the hostname
	 * @return the hostname
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="hostname"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getHostname();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the hostname
	 * 
	 * @param java.lang.String the new hostname value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setHostname(java.lang.String hostname);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public NodeHostnameBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * ホスト名が対応するノードファシリティを取得します。<BR>
	 * 
	 * @return ノードファシリティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-hostname"
	 *    role-name="HostnameToNode"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 *    batch-cascade-delete="true"
	 */
	public abstract NodeLocal getNode();
	
	/**
	 * ノードファシリティを格納します。<BR>
	 * 
	 * @param node ノードファシリティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setNode(NodeLocal node);
}
