/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.bean.SharedTableConstant;
import com.clustercontrol.sharedtable.SharedTable;

/**
 * ポーリングサービスとのコネクションを管理するクラス<BR>
 *
 * @version 3.1.0
 * @since 2.0.0
 */
public class PollingProcConnectionManager {
	
	protected static Log m_log = LogFactory.getLog( PollingProcConnectionManager.class );
    
	/**
	 * 収集値の共有テーブルを取得
	 * 
	 * @return　SharedTable
	 */
	public static SharedTable getSharedTable() throws NamingException {
		try {
			InitialContext ctx = new InitialContext();

			// SNMP収集値の共有テーブルをルックアップ
			SharedTable table = (SharedTable)ctx.lookup(SharedTableConstant.SHARED_TABLE_JNDI_NAME);
			return table;
		} catch (NamingException e) {
			m_log.error("getSharedTable:" + e.getMessage());
			throw e;
		}
	}
	
}
