/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;

/**
 * プロセス監視情報を削除するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class DeleteMonitorProcess extends DeleteMonitor{
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorProcess.class );

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	public boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {
		
		// プロセス監視情報を取得
		MonitorProcessInfoPK pk = new MonitorProcessInfoPK(m_monitorId, m_monitorTypeId);
		MonitorProcessInfoLocal processLocal = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// プロセス監視情報を削除
        processLocal.remove();
        
		boolean result = true;
        
		// SNMPポーラを停止
		ModifyPollingSchedule poller = new ModifyPollingSchedule();
		result = poller.deleteSchedule(
				m_monitor.getMonitorTypeId(),
				m_monitor.getMonitorId(),
				m_monitor.getFacilityId());
        
		return result;
	}
}
