/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import java.util.Calendar;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.process.bean.ProcessCheckInfo;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;
import com.clustercontrol.process.ejb.session.MonitorProcessRunManagementHome;
import com.clustercontrol.process.util.ProcessProperties;

/**
 * プロセス監視情報を登録するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddMonitorProcess extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorProcess.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// プロセス監視情報を設定
		ProcessCheckInfo process = m_monitorInfo.getProcessCheckInfo();
		
		MonitorProcessInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				process.getCommand(),
				process.getParam());
		
		// SNMPポーラに登録
		ModifyPollingSchedule poller = new ModifyPollingSchedule();
		boolean result = poller.addSchedule(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				m_monitorInfo.getFacilityId(), 
				m_monitorInfo.getRunInterval());
		
		return result;
	}
	
	/* (非 Javadoc)
	 * Quartzに登録するスケジュールを取得
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getCalendar(int)
	 */
	@Override
	public Calendar getCalendar(int interval) {
		// 値取得開始時間（秒）設定が60以上のものは59秒に設定する
		int startSecond = ProcessProperties.getProperties().getStartSecond();
		if(startSecond >= 60){
			startSecond = 59;
		}
		
		// 日時を設定
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, interval + startSecond);
        
        return calendar;
	}

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorProcessRunManagementHome.JNDI_NAME;
	}
}
