/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationPK;

/**
 * リソース監視の設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="CollectorScopeRelation"
 *           jndi-name="CollectorScopeRelation"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorScopeRelation" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *  
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_scope_relation"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *  
 *  @jboss.read-only
 *     read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_scope_relation"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorScopeRelation as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorScopeRelation as a where a.collectorId = ?1"  
 *    signature="java.util.Collection findByCollectorId(java.lang.String collectorId)" 
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationPK"
 *   
 */
public abstract class CollectorScopeRelationBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorScopeRelationPK ejbCreate(
			String collectorId,
			String facilityId,
			String parentFacilityId
			) throws javax.ejb.CreateException {
		
		this.setCollectorId(collectorId);
		this.setFacilityId(facilityId);
		this.setParentFacilityId(parentFacilityId);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param collectorId 収集ID
	 * @param facilityId ファシリティID
	 * @param parentFacilityId 親ファシリティID
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String collectorId,
			String facilityId,
			String parentFacilityId
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 収集IDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="collectorid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the collectorId.
	 */
	public abstract String getCollectorId();

	/**
	 * 収集IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param collectorId The collectorId to set.
	 */
	public abstract void setCollectorId(String collectorId);

	/**
	 * ファシリティIDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facilityid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);

	/**
	 * 親ファシリティIDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="parent_facilityid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the parentFacilityId.
	 */
	public abstract String getParentFacilityId();

	/**
	 * 親ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parentFacilityId The parentFacilityId to set.
	 */
	public abstract void setParentFacilityId(String parentFacilityId);

}
