/*
 
 Copyright (C) 2011 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoDetail;
import com.clustercontrol.notify.ejb.entity.NotifyDetail;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;

public class NotifyInfoCache {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( NotifyInfoCache.class );
	
	private static ConcurrentHashMap<String, NotifyInfo> cache =
		new ConcurrentHashMap<String, NotifyInfo>();
	
	private static void createCache(String notifyId) {
		// m_log.debug("createCache " + notifyId);
		m_log.info("createCache " + notifyId);
		NotifyInfoLocal notifyInfo = null;
		try {
			notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
		} catch (FinderException e) {
			m_log.error("createCache " + notifyId + ", " + e.getMessage());
		} catch (NamingException e) {
			m_log.error("createCache " + notifyId + ", " + e.getMessage());
		}
		if (notifyInfo == null) {
			return;
		}
		ArrayList<NotifyInfoDetail> detailList = new ArrayList<NotifyInfoDetail>();
		for (int priority : PriorityConstant.PRIORITY_LIST){
			NotifyDetail d = notifyInfo.getNotifyDetail(priority);
			NotifyInfoDetail detail = new NotifyInfoDetail();
			detail.setNotifyId(d.getNotifyId());
			detail.setPriority(d.getPriority());
			detail.setValidFlg(d.getValidFlg());
			detailList.add(detail);
		}
		NotifyInfo c = new NotifyInfo(
				notifyInfo.getNotifyId(),
				notifyInfo.getDescription(),
				notifyInfo.getNotifyType(),
				notifyInfo.getInitialCount(),
				notifyInfo.getRenotifyType(),
				notifyInfo.getRenotifyPeriod(),
				notifyInfo.getRegDate(),
				notifyInfo.getUpdateDate(),
				notifyInfo.getRegUser(),
				notifyInfo.getUpdateUser(),
				notifyInfo.getValidFlg(),
				detailList);
		cache.put(notifyId, c);
	}
	
	private static NotifyInfo getCache(String notifyId) {
		NotifyInfo notifyInfo = null;
		notifyInfo = cache.get(notifyId);
		if (notifyInfo == null) {
			createCache(notifyId);
			notifyInfo = cache.get(notifyId);
		}
		return notifyInfo;
	}
	
	// 通知の作成、変更、削除の際に呼び出すこと。
	public static void clear() {
		cache.clear();
		m_log.info("clearCache");
	}
	
	
	// キャッシュからプロパティを取得。
	public static String getDescription(String notifyId) {
		return getCache(notifyId).getDescription();
	}
	public static Integer getNotifyType(String notifyId) {
		return getCache(notifyId).getNotifyType();
	}
	public static Integer getInitialCount(String notifyId) {
		return getCache(notifyId).getInitialCount();
	}
	public static Integer getRenotifyType(String notifyId) {
		return getCache(notifyId).getRenotifyType();
	}
	public static Integer getRenotifyPeriod(String notifyId) {
		return getCache(notifyId).getRenotifyPeriod();
	}
	public static Timestamp getRegDate(String notifyId) {
		return getCache(notifyId).getRegDate();
	}
	public static Timestamp getUpdateDate(String notifyId) {
		return getCache(notifyId).getUpdateDate();
	}
	public static String getRegUser(String notifyId) {
		return getCache(notifyId).getRegUser();
	}
	public static String getUpdateUser(String notifyId) {
		return getCache(notifyId).getUpdateUser();
	}
	public static Integer getVaildFlg(String notifyId) {
		return getCache(notifyId).getValidFlg();
	}
	public static Integer getDetailValidFlg(String notifyId, int priority) {
		ArrayList<NotifyInfoDetail> detailList = getCache(notifyId).getNotifyInfoDetail();
		for (NotifyInfoDetail detail : detailList) {
			if (detail.getPriority() == priority) {
				return detail.getValidFlg();
			}
		}
		m_log.warn("getDetailValidFlg : " + notifyId + ", " + priority);
		return null;
	}
	
}
