/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.mdb;

import java.util.HashMap;
import javax.jms.DeliveryMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.factory.NotifyDispatcher;

/**
 *
 * 各種通知の振り分けを行う Message-Driven Bean <BR>
 * <p>監視結果のステータス／イベントへの通知 及び メールの送信、ジョブの実行、リモートのsyslogへのログ出力を行います。<BR>
 * イベントは抑制機能があり通知された順序が重要となるため、Singletonにし直列で処理を行います。
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NotifyNonPersistenceControlBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrolNotifyControlNonPersistence"
 * 
 * @jboss.depends name="user:service=HinemosService,name=HinemosService"
 * 
 * @jboss.container-configuration
 *  name="Hinemos Notification Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrolNotifyControlNonPersistence"
 * @jboss.destination-jndi-name name="queue/clustercontrolNotifyControlNonPersistence"
 *
 *--
 * <!-- end-xdoclet-definition -->
 **/
public class NotifyControlNonPersistenceBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	
	private static final long serialVersionUID = -4596765959814807231L;

	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( NotifyControlNonPersistenceBean.class );
	
	/** 通知情報キャッシュ */
	private static HashMap<String, NotifyInfo> m_notifyMap = null;
	
	/** コンテキスト情報 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/** キュー投げ込みの一貫性を保障するためのロック */
	private static final Object sendQueueLock = new Object();
	
	private static final int queueDeliveryMode = DeliveryMode.NON_PERSISTENT;
	
	/**
	 * コンテキスト情報を設定します。<BR>
	 * Message-Driven Bean がインスタンスプールに格納される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#setMessageDrivenContext(javax.ejb.MessageDrivenContext)
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * 未処理。Message-Driven Bean が生成される際に行う処理を実装します。
	 * @ejb.create-method 
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans 
	}
	
	/** 
	 * 未処理。Message-Driven Bean が削除される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#ejbRemove()
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * 引数で指定された受信メッセージを元に、ログ出力をおこないます。<BR>
	 * Message-Driven Bean で行うビジネスロジックを実装します。特定のメッセージを受信した場合のみ処理を行います。
	 * 受信メッセージは下記の通りです。
	 * 
	 * <p><li>{@link com.clustercontrol.notify.message.OutputNotifyGroupInfo} : 含まれている通知グループIDを元にキャッシュしている通知情報グループを取得します。取得した通知情報に従って、受信メッセージに含まれている通知出力基本情報を基に各種通知を行います。
	 * <p><li>{@link com.clustercontrol.notify.bean.NotifyInfoContext} : 含まれている通知情報を、キャッシュしている通知情報に反映します。
	 *
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 *
	 * @see com.clustercontrol.notify.message.OutputNotifyGroupInfo
	 * @see com.clustercontrol.notify.bean.NotifyInfoContext
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		m_log.debug("message received : " + message);
		NotifyDispatcher.onMessage(message, queueDeliveryMode);
		m_log.debug("message delivered : " + message);
	}
	
}